/**************************************************************************
Version identification:
@(#)lib.h	1.2	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  Seungjun Lee
 Date of creation: 2/11/91
 Description: C++ version of thor library routines

**************************************************************************/
/*  lib.h
 *
 *   Macro definitions for `C' fcn model writing (testing of I/O):
 *
 *	The SIO*test() macros are useful when using `C' structures to
 *		define the I/O being passed to the functional model.
 *
 *	The  IO*test() macros are useful when using integer arrays to
 *		define the I/O being passed to the functional model.
 *		The IO*test() macros require that the I/O are passed
 *		in arrays named: input[], output[], & state[].
 *
 *  Author:  Ernest J. Frey		7/6/84
 */
#define END	   0	/* flag to indicate end of linked-list	*/

#define TRUE       1	/* flag active				*/
#define FALSE      0	/* flag non-active			*/

#define STATE	int	/* type for internal states		*/

/*
 *	Macro definitions for fcn model writing (testing of I/O):
 */
		/*
		 *  Used to test inputs and outputs.
		 */
#define	SIOtest(Ei, Eo, Ni, No, ETYPE) if(Ei != Ni )\
	{fprintf(stderr,"\n\tERROR: ETYPE() - wrong # of inputs\n");\
		return(-1);\
	}\
	if ( Eo != No )\
	{fprintf(stderr,"\n\tERROR: ETYPE() - wrong # of outputs\n");\
		return(-2);\
	}

		/*
		 *  Used to test inputs, outputs, and states.
		 */
#define	SIOStest(Ei, Eo, Es, Ni, No, Ns, ETYPE) if(Ei != Ni )\
	{fprintf(stderr,"\n\tERROR: ETYPE() - wrong # of inputs\n");\
		return(-1);\
	}\
	if ( Eo != No )\
	{fprintf(stderr,"\n\tERROR: ETYPE() - wrong # of outputs\n");\
		return(-2);\
	}\
	if ( Es != Ns )\
	{fprintf(stderr,"\n\tERROR: ETYPE() - wrong # of states\n");\
		return(-3);\
	}

		/*
		 *  Used to test inputs, outputs, states, and biputs.
		 */
#define	SIOSBtest(Ei, Eo, Es, Eb, Ni, No, Ns, Nb, ETYPE) if(Ei != Ni )\
	{fprintf(stderr,"\n\tERROR: ETYPE() - wrong # of inputs\n");\
		return(-1);\
	}\
	if ( Eo != No )\
	{fprintf(stderr,"\n\tERROR: ETYPE() - wrong # of outputs\n");\
		return(-2);\
	}\
	if ( Es != Ns )\
	{fprintf(stderr,"\n\tERROR: ETYPE() - wrong # of states\n");\
		return(-3);\
	}\
	if ( Eb != Nb )\
	{fprintf(stderr,"\n\tERROR: ETYPE() - wrong # of biputs\n");\
		return(-4);\
	}

		/*
		 *  Used to test inputs and outputs.
		 */
#define	IOtest(Ni, No, ETYPE) if(input[0] != Ni )\
	{fprintf(stderr,"\n\tERROR: ETYPE() - wrong # of inputs\n");\
		return(-1);\
	}\
	if ( output[0] != No )\
	{fprintf(stderr,"\n\tERROR: ETYPE() - wrong # of outputs\n");\
		return(-2);\
	}

		/*
		 *  Used to test inputs, outputs, and states.
		 */
#define	IOStest(Ni, No, Ns, ETYPE) if(input[0] != Ni )\
	{fprintf(stderr,"\n\tERROR: ETYPE() - wrong # of inputs\n");\
		return(-1);\
	}\
	if ( output[0] != No )\
	{fprintf(stderr,"\n\tERROR: ETYPE() - wrong # of outputs\n");\
		return(-2);\
	}\
	if ( state[0] != Ns )\
	{fprintf(stderr,"\n\tERROR: ETYPE() - wrong # of states\n");\
		return(-3);\
	}

		/*
		 *  Used to test inputs, outputs, states, and biputs.
		 */
#define	IOSBtest(Ni, No, Ns, Nb, ETYPE) if(input[0] != Ni )\
	{fprintf(stderr,"\n\tERROR: ETYPE() - wrong # of inputs\n");\
		return(-1);\
	}\
	if ( output[0] != No )\
	{fprintf(stderr,"\n\tERROR: ETYPE() - wrong # of outputs\n");\
		return(-2);\
	}\
	if ( state[0] != Ns )\
	{fprintf(stderr,"\n\tERROR: ETYPE() - wrong # of states\n");\
		return(-3);\
	}\
	if ( biput[0] != Nb )\
	{fprintf(stderr,"\n\tERROR: ETYPE() - wrong # of biputs\n");\
		return(-4);\
	}
