/**************************************************************************
Version identification:
@(#)ipc.h	1.3	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  Anders Wass
 Date of creation: 2/11/91
 Description:
**************************************************************************/

#define ipcRCSID "$Header: ipc.h,v 1.1 86/11/30 03:58:16 salz Exp $"

/*
 * Inter-Process Communication definitions
 */

#define MAXDATASIZE	4000	/* max number of inputs */

typedef enum
  {
    ADDSIGNAL,			/* Add new signal to net list (at end) */
    DELETESIGNAL,		/* Delete signal from net list */
    MOVESIGNAL,			/* Rename a signal on the net list */
    SIGVALUES,			/* New signal values */
    STOP,			/* Stop the simulator */
    CONT,			/* Restart the simulator */
    IPC_OK,			/* Generic return value for Sends */
    IPC_ERR			/* Communication error */
  } MsgType;


typedef struct
  {
    MsgType  type;
    int      length;		/* data size, that follows the header */
  } Header;


typedef struct
  {
    Header   header;
    char     data[ MAXDATASIZE ];
  } Message;


typedef struct			/* format for rename signal message */
  {
    int   signum;			/* signal number */
    int   len;				/* length of name + 1 */
    char  name[ MAXDATASIZE ];		/* new name */
  } RenSigMsg;

typedef struct		/* format for delete signal message */
  {
    int  signum;			/* signal number to delete */
  } DelSigMsg;

typedef struct			/* format for add signal message */
  {
    int   signum;			/* signal that it replaces */
    int   len;				/* length of the name + 1 */
    char  name[ MAXDATASIZE ];		/* name of new signal */
  } AddSigMsg;


	/* Exports */
#ifdef __cplusplus
extern MsgType    ipc_Receive(int, char**, int*);
extern MsgType    ipc_Send(int, const char*, int, MsgType);
#else
extern MsgType    ipc_Receive();
extern MsgType    ipc_Send();
#endif
