static const char file_id[] = "funpack.cc";
/**************************************************************************
Version identification:
@(#)funpack.cc	1.5	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  Seungjun Lee
 Date of creation: 2/11/91
 Description: C++ version of thor library routines

**************************************************************************/
/* funpack(arout,msb,lsb,number)
 *
 * unpack number and convert to array of arout
 *
 * procedure :
 *	convert the input number and placce in the
 *	specified bits of the array arout.
 *
 *	input		output		bidirectional
 *
 *	number		arout
 *	msb		error
 *	lsb
 *
 */

#include "uarp.h"
#include "libarp.h"

int funpack(
int *arout, int msb, int lsb, int number)

{


int error;

error = PASSED;
error |= fckmsize(msb,lsb);

if (error == PASSED)
{	if (lsb >= msb)
	{	while (msb <= lsb)
		{	arout[lsb--] = number & 0x1;
			number = number >>1;
		}
	}
	else
	{	while (lsb <= msb)
		{	arout[lsb++] = number & 0x1;
			number = number >>1;
		}
	}
} else
{
	if (error <= PASSED)
	{
		ferr(error,"FUNPACK: No unpacking done due to:");
	}
}

return(error);
}

/* DEBUG**********DEBUG**********DEBUG**********DEBUG */
#ifdef DEBUG
#define SIZE 8
#define	TRUE 1
#define	FALSE 0
main(int argc, char *argv[])
{
int arout[SIZE];
/* {lsb,,,,,msb} */
static int answ[]  = {1,1,1,0,1,0,0,0};
int number = 23;
int 	msbo	= 7,
		lsbo	= 0
	;
int rval = 0;
int i,pvaro;
int	iflag = TRUE;
char c;

FDUMPOFF;
while (iflag == TRUE)
{
	if (argc > 1)
	{
		/* interactive session */
		printf("UNPACKing a number.\n");
		printf("Enter number to be unpacked: ");
		scanf("%d",&number);
		printf("Enter msb, lsb for output group:");
		scanf("%d,%d",&msbo,&lsbo);
	} else
		iflag = FALSE;

	pvaro = funpack(arout,msbo,lsbo,number);
	
	printf("number = %d\n",number);
	printf("\ngrout\n");
	fprval(arout,msbo,lsbo);
	if (iflag == FALSE)
	{
	for (i=0;i<SIZE - 1;i++)
		if (arout[i] != answ[i])
		{
			rval = 1;
			printf("\nFAILED at bit: %d\n",i);
		}
	printf("\n\nEND of TEST\n");
	}
	/* end of test */
	if (argc > 1)
	{
		rval = 0;
		printf("Continue with test (y or n)? ");
		getchar();
		if ((c=getchar()) == 'y' || c == 'Y')
			iflag = TRUE;
		else
			iflag = FALSE;
	}
}
exit(rval);
}
#endif


/* Overloaded definition for Ptolemy interface */

int funpack(
MultiThorPort &arout, int msb, int lsb, int number)

{


int error;

error = PASSED;
error |= fckmsize(msb,lsb);

if (error == PASSED)
{	if (lsb >= msb)
	{	while (msb <= lsb)
		{	arout[lsb--] = number & 0x1;
			number = number >>1;
		}
	}
	else
	{	while (lsb <= msb)
		{	arout[lsb++] = number & 0x1;
			number = number >>1;
		}
	}
} else
{
	if (error <= PASSED)
	{
		ferr(error,"FUNPACK: No unpacking done due to:");
	}
}

return(error);
}
