static const char file_id[] = "fsetword.cc";
/**************************************************************************
Version identification:
@(#)fsetword.cc	1.5	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  Seungjun Lee
 Date of creation: 2/11/91
 Description: C++ version of thor library routines

**************************************************************************/
/* fsetword(array,msb,lsb,number)
 *
 * Set word to number.
 *
 * procedure :
 *	Set all specified bits in an array to a given value.
 *
 */

#include "lib.h"
#include <stdio.h>
#include "uarp.h"
#include "libarp.h"

int
fsetword(
 register int	*array,
 register int	 msb,
 register int	 lsb,
 register int	 number)
{


	if (msb <= lsb)
	{
		array += msb;
		while (msb++ <= lsb)
			*array++ = number;
	}
	else
	{
		array += lsb;
		while (lsb++ <= msb)
			*array++ = number;
	}
	return(PASSED);
}
/*------------------------------------------------------------------*/
#ifdef DEBUG
#define SIZE 8
main(int argc, char *argv[])
{
 static int	arin[SIZE];
	int 	msb = 0;
	int	lsb = SIZE-1;
	int	answ;
	int	i;
	int	val = 5;

	while(1)
	{
		answ = fsetword(arin, msb, lsb, val);

		switch ( answ )
		{
		    case PASSED:
			break;
		    default:
			printf("\Return code != PASSED, but = %d\n",answ);
			break;
		}
		if ( argc == 1 )
		{
			for (i=0;i<=SIZE - 1;i++)
			{
			   if ( arin[i] != val )
				printf( "Test failed at bit #%d:  %d != %d\n",i,arin[i], val);
			}
			printf("\n\nEND of TEST\n");
			break;
		}
		else
		{
			printf("msb=%d  lsb=%d   arin=\n",msb, lsb);
			for (i=0;i<=SIZE - 1;i++)
				printf("%1d ",arin[i]);
			printf("\nEND of TEST\n\n");

			printf("enter msb,lsb {0,%d}: ", SIZE-1);
			scanf("%d,%d",&msb, &lsb);
			printf("enter value: ");
			scanf("%d",&val);
		}
	}
}
#endif


/* Overloaded definition for Ptolemy interface */

int
fsetword(
 MultiThorPort  &array,
 register int	 msb,
 register int	 lsb,
 register int	 number)
{

	int i = 0;

	if (msb <= lsb)
	{
/*		array += msb; */
		i += msb;
		while (msb++ <= lsb)
/*			*array++ = number; */
			array[i++] = number;
	}
	else
	{
/*		array += lsb; */
		i += lsb;
		while (lsb++ <= msb)
/*			*array++ = number; */
			array[i++] = number;
	}
	return(PASSED);
}
