static const char file_id[] = "fckmsize.cc";
/**************************************************************************
Version identification:
@(#)fckmsize.cc	1.5	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  Seungjun Lee
 Date of creation: 2/11/91
 Description: C++ version of thor library routines

**************************************************************************/
/* fckmsize(msb,lsb)
 *
 * Verifies that array size is less than MAXBUSLEN_ bits.
 *
 * Procedure :
 *	If array size is larger than MAXBUSLEN_ bits then
 *	indicate and error has been made
 *
 * Return Value:
 *	PASSED	   - okay
 *	MSIZEERROR - abs(msb-lsb) >= MAXBUSLEN_
 */
#include "lib.h"
#include <stdio.h>
#include "uarp.h"
#include "libarp.h"

int
fckmsize(
 register int msb,
 register int lsb)
{

	int error;

	if (abs(msb - lsb) >= MAXBUSLEN_)
	{
	   fprintf(stderr,"\nERROR: Array is too large (> %d bits) (msb= %d,lsb= %d)\n", MAXBUSLEN_, msb,lsb);
	   error = MSIZEERROR;
	}
	else
	{
	   error = PASSED;
	}
	return(error);
}
/*------------------------------------------------------------------*/
#ifdef DEBUG
main()
{
	if ( fckmsize(31,0) != PASSED
	  || fckmsize(0,31) != PASSED
	  || fckmsize(0,0)  != PASSED
	  || fckmsize(31,31) != PASSED
	  || fckmsize(0,32) != MSIZEERROR
	  || fckmsize(1,33) != MSIZEERROR
	  || fckmsize(32,0) != MSIZEERROR )
	{
		printf("\nfckmsize: FAILED at least one test\n");
	}
	else
	{
		printf("\nfckmsize: PASSED ALL TESTS\n");
	}
}
#endif
