/* 
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY
*/
static const char file_id[] = "ThorWormhole.cc";
// This may look like C code, but it is really -*- C++ -*-

///////////////////////////////////////////////////////////////////////////
//
// Version identification:
// @(#)ThorWormhole.cc	1.14 3/16/93
//
// Copyright  (c) 1990	The Regents of the University of California,
//				All Rights Reserved.
//
// Programmer:	Seungjun Lee
// Created:	12/03/90
// Revisions:	
//
// Description:
// ------------
//     Thor domain specific definition
//
///////////////////////////////////////////////////////////////////////////

#ifdef __GNUG__
#pragma implementation
#endif
#include "ThorWormhole.h"
#include "ThorScheduler.h"
#include "CircularBuffer.h"


	///////////////////////////////
	// class ThorWormhole methods
	///////////////////////////////

void ThorWormhole :: go()
{
     // synchronize the two domains
     scheduler()->setCurrentTime((double)getCurTime());

     // get particles for input ports
     BlockPortIter next(*this);

     for (int i = numberPorts(); i > 0; i--)
	  (next++)->receiveData();

     // run the inner scheduler
     Wormhole::run();
}

// cloner -- clone the inside and make a new wormhole from that.
Block* ThorWormhole :: clone() const
{
	LOG_NEW; return new ThorWormhole(gal.clone()->asGalaxy());
}

// makeNew, analogous to clone.
Block* ThorWormhole :: makeNew() const
{
LOG_NEW; return new ThorWormhole(gal.makeNew()->asGalaxy(),
				target->cloneTarget());
}

// sumUp();  If the inner domain is timed and stopBeforeDeadlocked,
// schedule the wormhole into the time-wheel
void ThorWormhole :: sumUp(){
     ThorStar* starP = this;	// myself as a ThorStar.
     BlockPortIter next(*starP);

     for (int i = starP->numberPorts(); i > 0; i--)
	  (next++)->sendData();

     if (scheduler()->stopBeforeDeadlocked())
	     selfSched((TimeType)scheduler()->now(), SELF0, starP);
}

 

	////////////////////////////////
	// methods for ThortoUniversal
	////////////////////////////////

void ThortoUniversal :: receiveData()
{
     // 1. get data.

     // The ThorScheduler calls this routine when an event is fetched from the
     // timeWheel to a ThorStar. It takes a particle from the Geodesic and store
     // it in the porthole's myBuffer.
     // This is different from the way it is handled by the Thor & SDF schedulers 
     // get the pointer to the particle in myBuffer ...
     IntParticle* pmB = (IntParticle*)*myBuffer->here();   
  
     // then get the particle from the Node...
     IntParticle* pmG = (IntParticle*)node()->getParticle(); 
  
     // copy the value from Node if it is new
     if (node()->nodeHasChanged()){
          *pmB = *pmG;	      
  
          // and mark that new data is available.
          tokenNew = TRUE;		     
     
          if (ThortoUniversal :: isItInput()) {      // if it is input
     
               // 2. pass currentTime from outside to inside
               timeMark = (float)((ThorStar*)parent())->getCurTime();
     
          } // if it is output, time stamp is set from the inside.

	  node()->clrNodeHasChanged();
     }
     else
	  tokenNew = FALSE;

     // 3. transfer data
     transferData();
}

void ThortoUniversal :: initialize() {
	PortHole :: initialize();
	ToEventHorizon :: initialize();
}

int ThortoUniversal :: isItInput() const 
	{ return EventHorizon :: isItInput(); }
int ThortoUniversal :: isItOutput() const 
	{ return EventHorizon :: isItOutput(); }

EventHorizon* ThortoUniversal :: asEH() { return (EventHorizon*) this; }

	//////////////////////////////////
	// methods for ThorfromUniversal
	//////////////////////////////////

// copy the new data into the input ports of Thor stars
// schedule the star if the value has been changed
void ThorfromUniversal :: sendData()
{
     // Transfer data from the ghostport,
     // if it is an output from a wormhole to a node
     if (ThorfromUniversal :: isItOutput()){
	ghostAsPort()->receiveData();
	return;
     }

     // If it is an input to a Thor domain, 
     // and it has a new data, 
     // schedule a star into the time-wheel
     ThorPortHole& pThor = *(ThorPortHole*) far();
     Particle& pmB = *((Particle*)(*myBuffer->here()));

     //  return if the new data is the same as the old data
     int i1 = (int)pThor.getNodeParticle();
     int i2 = (int)pmB;
     
//     if ((int)pThor.get() == (int)pmB)
     if (i1 == i2)
          return;

     // copy the new data and schedule the parent into the time-wheel
//     pThor = (int) pmB;
     node()->setNodeValue(i2);
     timeMark = ghostPort->getTimeMark();
     ThorStar* sThor = (ThorStar*)pThor.parent();
//   selfSched(sThor->getCurTime(), SELF0, sThor);
     schedStar((int)timeMark, SELF0, sThor);
     return;
}

void ThorfromUniversal :: initialize() {
	PortHole :: initialize();
	FromEventHorizon :: initialize();
}

int ThorfromUniversal :: isItInput() const 
	{ return EventHorizon :: isItInput(); }
int ThorfromUniversal :: isItOutput() const 
	{ return EventHorizon :: isItOutput(); }

EventHorizon* ThorfromUniversal :: asEH() { return (EventHorizon*) this; }

