/**************************************************************************
Version identification:
@(#)ThorScheduler.h	1.14 11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  Seungjun Lee
 Date of creation: 6/19/90
 Revised: 9/13/90
          TimeWheel.h is merged into ThorScheduler.h

A Time-Wheel Structure Is Defined and Thor Scheduler Is Rewritten in C++

**************************************************************************/
#ifndef _ThorScheduler_h
#define _ThorScheduler_h 1
#ifdef __GNUG__
#pragma interface
#endif

#include "Scheduler.h"
#include "DoubleLink.h"
#include "ThorStar.h"
#include "ThorNode.h"

#define ElemList DoubleLinkList


	//////////////////////////////////////
	// class OutChange
	//////////////////////////////////////

class OutChange
{
public:
	PortHole* pin;
	int       val;

	OutChange(PortHole *ph, int value)
		{ pin = ph; val = value; }
		
};


//
// The basic structure for time wheel...
//
	//////////////////////////////////////
	// class TimeSlot
	//////////////////////////////////////

class TimeSlot 
{
	TimeType        time;      // time value of this slot
	ElemList        gen;       // list of generators
	ElemList        mon;       // list of monitors
	ElemList        changes;   // list of output changes
	
public:
	ElemList& callGenerators() { return gen; }
	void stimOutputs(ElemList* nodelist);
	void callMonitors();
	void putGen(ThorStar* elem) { if (!gen.find(elem)) gen.append(elem); }
	void putMon(ThorStar* elem) { if (!mon.find(elem)) mon.append(elem); }
	void putOut(OutChange*  elem) { changes.append(elem); }
	void deleteGen(ThorStar* elem) { gen.remove(elem); }
	void deleteMon(ThorStar* elem) { mon.remove(elem); }
	int  getTime() { return time; }

	TimeSlot(TimeType currtime){
		time = currtime; 
	}
};

	//////////////////////////////////////
	// class TimeWheel
	//////////////////////////////////////

class TimeWheel
{
private:
	// Size of the time-wheel
	int  size;
	// Index of the current pointer
	int  current;
	// Pointer array to linked list of time slot
	DoubleLinkList** buffer;

public:
	// Argument is the size of the array to allocate
	TimeWheel(int i);

	// Reset all the array and go back to time zero
	void reset();

	// Find the time slot where the next event is schduled
	// and update current time
	// Return NULL if there's no future event
	TimeSlot* get(TimeType& currTime, TimeType maxTime);

	// Find a time slot of given time
	// Create one if it doesn't exist
	TimeSlot* findSlot(TimeType time);

};
	

	////////////////////////////
	// ThorScheduler
	////////////////////////////


class ThorScheduler : public Scheduler {

	// Stoping condition of the scheduler
	TimeType stopTime;

	// List of elements to be fired at a certain time
	ElemList elemList;

	// List of nodes to be evaluated at a certain time
	ElemList nodeList;

public:
	// A time-wheel is implemented as an event queue
	// in Thor scheduler.
	TimeWheel *timeWheel;

	// Current time: made public to be seen by stars
	TimeType thorTime;

        // set the currentTime
        void setCurrentTime(double val) {thorTime = (TimeType)val ;}

	// Set up the stopping condition.
	void setStopTime(TimeType limit) {stopTime = limit ;}
	void setStopTime(double limit) {stopTime = (int)limit ;}
	double getStopTime() { return double(stopTime);}

	// The setup function runs the INIT section of all the atomic 
	// blocks and schedules generators and monitors at time zero
	void setup();

	// The run function resumes the run where it was left off.
	int run();

	// Resolve node values and get the list of elements affected
	void evaluateNodes();

	// Fire elements in the elemList and get the list of nodes affected
	void stimElements(ElemList& list);

	// Schedule an element into the time-wheel
	// defined as an external function friend to TimeWheel...
//	void selfSched(TimeType time, int priority, ThorStar* elem);

	// Remove an element from the time-wheel
	// defined as an external function friend to TimeWheel...
//	void selfUnsched(TimeType time, ThorStar* elem);

	// Schedule a delayed output change into the time-wheel
	// defined as an external function friend to TimeWheel...
//	void schedOut(TimeType time, int value, ThorPortHole* pin);


        // Display the static schedule for SDF wormholes...
        StringList displaySchedule();

	// Constructor sets default options
	ThorScheduler () { INC_LOG_NEW; timeWheel = new TimeWheel(100); stopTime = 100;}
};

#endif
