static const char file_id[] = "ThorPrint.cc";
/****************************************************************************
 * SCCS Version identification :
 * @(#)ThorPrint.cc	1.8 11/25/92
 *
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY
 *
 * Programmer: Anders Wass
 * Date of creation:	5/13/91
 * Modification:	6/7/91	Anders Wass <awa>
 *				Using a string buffer to store stderr
 *				messages so they can go to the appropriate
 *				stream when the star exits.
 *
 * This file defines the methods int file ThorPrint.h used for error
 * reporting inside the Thor models. It is using the Error class and
 * cout object to generate errors and find the appropriate streams to
 * use for the output messages.
 *
 *****************************************************************************/

#include <stream.h>
#include "Scheduler.h"
#include "NamedObj.h"
#include "ThorPrint.h"
#include <stdarg.h>
#include "miscFuncs.h"

char ThorPrint::errMsgBuf[BUFSIZ] = "";

static char stringbuf[BUFSIZ];

#if defined(hpux) && defined(__GNUG__)
// HP-UX and gcc disagree over what a va_list is, so the standard vsprintf
// cannot be used.  This is one that will work with libg++ ONLY.  Sorry for
// the terrible hack.  It depends on the existence of the "vform"
// function, which as far as I know isn't standard.

#include <strstream.h>

static int fake_vsprintf(char* string,const char* format, _G_va_list args)
{
	strstreambuf stream(string, -1, string);
	int ret = stream.vform(format, args);
	stream.sputc(0);
	return ret;
}
#define vsprintf fake_vsprintf
#endif /* end of HP hack */

void ThorPrint :: Thor_fprintf(FILE* fp, const char* format, ...)
{
    va_list args;
    va_start(args,format);
    vsprintf(stringbuf,format,args);
    va_end(args);
    if (fp == stdout) {
	cout << stringbuf;
	cout.flush();
    }
    else if (fp == stderr)
	strcat(errMsgBuf,stringbuf);
    else if (fp && fp != stdin)
	:: fputs(stringbuf,fp);
    else
	Error :: abortRun("ThorPrint::fprintf: ",
			  "Bad file pointer. Can't write.\n");
}

void ThorPrint :: Thor_printf(const char* format, ...)
{
    va_list args;
    va_start(args,format);
    vsprintf(stringbuf,format,args);
    va_end(args);
    cout << stringbuf;
    cout.flush();
}

void ThorPrint :: Thor_fputs(const char* str, FILE* fp)
{
    if (fp == stdout) {
	cout << str;
	cout.flush();
    }
    else if (fp == stderr)
	strcat(errMsgBuf,str);
    else if (fp && fp != stdin)
	:: fputs(str,fp);
    else
	Error :: abortRun("ThorPrint::fputs: ",
			  "Bad file pointer. Can't write.\n");
}
