static const char file_id[] = "ThorExpandSig.cc";
//////////////////////////////////////////////////////////////////////////////
//
// SCCS Version identification:
// @(#)ThorExpandSig.cc	1.6	11/26/92
//
/*
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY
*/
//
// Programmer:		Anders Wass
// Date of creation:	6/12/91
// Modification:
//
//
// Description:
//	This file contains a function that takes a string containing words
//	separated with whitespaces. Each word is examined for a square
//	bracket construction at the end of the name. The contents within the
//	brackets has to be a single digit (in[3]) or a digit range notation
//	(in[3-0]). A range notation will be expanded to single digit name
//	(as for in[3-0] that will become in[3] in[2] in[1] in[0]).
//
//////////////////////////////////////////////////////////////////////////////

#include <ctype.h>
#include "StrBuf.h"
#include "miscFuncs.h"

static char expbuf[2*BUFSIZ];

char *mystrcat(char* buf, const char* s)
{
    if (*buf) strcat(buf," ");
    return strcat(buf,s);
}

void getint(char* buf, const char* &sptr)
{
    register int i=0;
    while (*sptr && isdigit(*sptr))
	buf[i++] = *sptr++;
    buf[i] = '\0';
}

int expandSig(const char* namevec, char* &newvec)
{
    StrBuf namebuf = namevec;
    const char *ptr;
    expbuf[0] = '\0';
    while (ptr = namebuf.getword()) {
	const char *s;
	int namelen, hasBrack = 0;
	for (s=ptr; *s && *s != '['; s++)
	    if (*s == ']') hasBrack++; // if we find this, then we have a
				       // syntax error
	if (*s++) {
	    char ibuf[16];	// more than enough ...
	    int start = -1, stop = -1;

	    namelen = s-ptr-1;
	    if (!namelen) return -3;
	    getint(ibuf,s);

	    if (*s == '[') return -2; // syntax error

	    if (*s == ']') {	// single digit, need no expansion
		if (!ibuf[0]) return -2; // syntax error
		mystrcat(expbuf,ptr);
	    }
	    else if (*s++ == '-') { // digit range
		char tempbuf[128];
		char tname[128];

		strncpy(tname,ptr,namelen);
		tname[namelen] = '\0';

		if (*ibuf) start = atoi(ibuf);
		getint(ibuf,s);
		if (*ibuf) stop = atoi(ibuf);

		if (*s != ']') return -2; // syntax error

					  // need at least one index,
					  // otherwise syntax error.
		if (start == -1 && stop == -1) return -2;

		if (start == -1) // if we have one limit, default the other
		    start = 0;	 // to 0
		else if (stop == -1)
		    stop = 0;

		register int i;
		if (stop > start) // do the name expansion for the range ...
		    for (i=start; i <= stop; i++) {
			sprintf(tempbuf,"%s[%d]",tname,i);
			mystrcat(expbuf,tempbuf);
		    }
		else
		    for (i=start; i >= stop; i--) {
			sprintf(tempbuf,"%s[%d]",tname,i);
			mystrcat(expbuf,tempbuf);
		    }
	    }
	    else return -2;	// syntax error !!!
	}
	else {
	    if (hasBrack) return -2; // syntax error, missing bracket
	    mystrcat(expbuf,ptr);
	}
    }
    if (expbuf[0]) {
	newvec = expbuf;
	return 0;
    }
    else {
	newvec = (char*) 0;
	return -1;
    }
}
