/****************************************************************************
 * SCCS Version identification :
 * @(#) 1.2 11/25/92
 *
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY
 *
 * Programmer: Anders Wass
 * Date of creation: 6/7/91
 *
 * This header file defines a class that interfaces the errors reported from
 * inside the Thor models. It is using the ThorPrint class to overload the
 * traditional print functions so the messages will go to appropriate streams.
 * At construction time, the star block and the buffer holding the message
 * must be specified.
 *
 * Usage:
 *	Declare a variable
 * ``ThorErrHandler errHandler(this,ThorPrint::getErrMsgBuf(),&StatErrHandler);''
 * (done by pepp) in start, go, and wrapup methods. Then assign this
 * variable to the static pointer variable StatErrHandler like this: 
 * ``ThorErrHandler* StatErrHandler = NULL; // outside the class declaration !!!''
 * ``StatErrHandler = &errHandler; // inside the methods''
 * EXITMOD(x) should then be defined as ``StatErrHandler->status = x; return;''
 * and exit(x) should be defined as
 * ``StatErrHandler->status = x; StatErrHandler->flush(); return;''
 *
 *****************************************************************************/
# ifndef _ThorErrHandler_h
# define _ThorErrHandler_h 1

# ifndef MSGSIZE
# define MSGSIZE 512
# endif

class NamedObj;

class ThorErrHandler {
private:
    char* msgBuf;
    NamedObj* whoIam;
    ThorErrHandler** statRef;
public:
    int status;
    ThorErrHandler(NamedObj* b, char* ebuf, ThorErrHandler** ref) :
    status (0), whoIam (b), msgBuf (ebuf), statRef (ref)
    { *ebuf = '\0'; }		// clear buffer from old messages ...
    void flush();		// so messages can be flushed even if the
				// destructor might not be called (in case
				// of software traps ... etc.)
    ~ThorErrHandler() { flush(); if (statRef) *statRef = 0;}
};

# endif
