
/*
 *
 * Version identification:
 * @(#)txtwindow.c	1.1 8/26/91
 *
 */

#ifndef lint
static char rcsid[] = "$Header: txtwindow.c,v 1.2 87/05/05 13:35:00 rokicki Exp $";
#endif

/*
 * Text window manager.
 */

#include <stdio.h>
#include "defs.h"

#define	MAXLINES	10
#define	MINLINES	2
#define	XMARGIN		2
#define	MAXCOLS		((MAXWINDOWSIZE - 2 * XMARGIN + 1)/metrics.charWidth)
#define	DEFXLOC		0		/* default text window position */
#define	DEFYLOC		0

#define	CHARHEIGHT	(metrics.charHeight + 2)
#define	CHARWIDTH	(metrics.charWidth)

static char    *(lines[ MAXLINES ]);	/* table of line buffers */
static int     nLines ;			/* number of lines in window */
static int     nCols;			/* number of columns in window */
static int     currLine;		/* current line of text */
static XCoord  xPos;			/* x position of text cursor */
static YCoord  yPos;			/* y position of text cursor */
static char    *pos;			/* current position in line buffer */
static XCoord  maxXpos;			/* rightmost text coordinate */

extern int descent;


/*
 * Initialize (reinitialize) the text window.  Allocate space for buffers
 * and initialize all parameters and pointers.
 */
void InitTextWindow( lin )
  int  lin;
  {
    int  i;
    int  col;
    int  errflag = 0;

    if( lin < 0 )		/* negative values won't change nLines */
	lin = nLines;
    if( (lin > MAXLINES) || (lin < MINLINES) )
      {
	char  s[ 15 ];
	
	PRINT( "Text lines must be between " );
	sprintf( s, "%d and %d\n", MINLINES, MAXLINES );
	PRINT( s );
	return;
      }

    col = ( XWINDOWSIZE - XMARGIN - XMARGIN + 1 ) / CHARWIDTH;
    if( col > MAXCOLS )
	col = MAXCOLS;

    for( i = nLines; i < lin; i++ )
      {
	if( lines[ i ] == NULL )
	  {
	    lines[ i ] = Malloc( MAXCOLS + 3 );	/* not allocated yet */
	    if( lines[ i ] == NULL )
	      {
		if( i < MINLINES )
		  {
		    ANALYZER_Crash( "Not enough memory for text window" );
		  }
		else
		  {
		    lin = i;	/* keep as many lines as we have */
		    errflag = 1;
		    break;
		  }
	      }
	  }
	*(lines[ i ]) = '\0';	/* newly created line, clear it */
      }

    text.bot = 0;
    text.left = 0;
    text.top = ( lin * CHARHEIGHT ) + 1;
    text.right = XWINDOWSIZE - 1;
    maxXpos = text.left + ( col - 1 ) * CHARWIDTH + XMARGIN;
    nCols = col;
    if( lin == nLines )
      {
	if( xPos >= maxXpos )
	    xPos = maxXpos - CHARWIDTH;
      }
    else
      {
	if( (pos == NULL) || (currLine >= lin) )
	  {
	    pos = lines[ 0 ];
	    *pos = '\0';
	    xPos = XMARGIN;
	    yPos = text.top - CHARHEIGHT;
	    currLine = 0;
	  }
	else
	    yPos = ( lin - currLine - 1 ) * CHARHEIGHT + 1;
      }
    nLines = lin;
    if( errflag )
	PRINT( "not enough memory for all text lines\n" );

  }


static char  sc[ 2 ] = " ";		/* Character buffer */
static char  mCURSOR[] = " ";		/* a space in inverse video */


/*
 * Display 1 character on the text window.  Backspace and new-line
 * characters are interpreted accordingly, no other control characters
 * are available, they will just display a 'funny' symbol.
 */
void PUTC( c )
  char  c;
  {
    mySetColors( BLACK, WHITE );

    if( c == '\b' )				/* backspace */
      {
	if( xPos == XMARGIN )
	    return;
	myMoveTo( xPos, yPos );		/* Erase old cursor */
	myCharStr( mCURSOR, 1 );
	pos--;
	*pos = '\0';
	xPos -= CHARWIDTH;
      }
    else if( c == '\n' || c == '\r' )		/* new line */
      {
	*pos = '\0';
        myMoveTo( xPos, yPos );		/* Erase old cursor */
        myCharStr( mCURSOR, 1 );
	NewLine();
      }
    else
      {					/* displayable character */
	*sc = c;
        myMoveTo( xPos, yPos );		/* Erase old cursor */
        myCharStr( sc, 1 );
	*pos = c;

	if( xPos == maxXpos )
	    NewLine();
	else
	  {
	    pos++;
	    *pos = '\0';
	    xPos += CHARWIDTH;
	  }
      }
      mySetColors( WHITE, BLACK );		/* display new cursor */
      myMoveTo( xPos, yPos );		/* Erase old cursor */
      myCharStr( mCURSOR, 1 );
  }


/*
 * Display a string of text in the text window.  The only control character
 * handled by this routine is the new-line character.
 */
void PRINT( txt )
  char  *txt;
  {
    char    *s;
    XCoord  x;
    int     len;

    len = 0;
    s = txt;
    x = xPos;
    mySetColors( BLACK, WHITE );
    while( *s != '\0' )
      {
	if( *s == '\n' || *s == '\r' )
	  {
	    *pos = '\0';
	    if( len > 0 )
	      {
		myMoveTo( xPos, yPos );
		myCharStr( txt, len );
	      }
	    else
	      {
		myMoveTo( xPos, yPos );
		myCharStr( " ", 1 );
	      }
	    NewLine();
	    x = xPos;
	    txt = ++s;
	    len = 0;
	  }
	else
	  {
	    *pos++ = *s++;
	    len++;
	    if( x == maxXpos )
	      {
                myMoveTo( xPos, yPos );
		myCharStr( txt, len );
		NewLine();
		x = xPos;
		txt = s;
		len = 0;
	      }
	    else
	  	x += CHARWIDTH;
	  }
      }
    if( len > 0 )
      {
	myMoveTo( xPos, yPos );
	myCharStr( txt, len );
	*pos = '\0';
      }
    xPos = x;
    mySetColors( WHITE, BLACK );
    myMoveTo( xPos, yPos );
    myCharStr( mCURSOR, 1 );
}


/*
 * Flush the text output 
 */
FLUSH()
 {
   XFlush(display) ;

 }

NewLine()
  {
    register int  i;
    
    currLine++;
    if( currLine == nLines )		/* scroll window up 1 line */
      {
        mySetColors( BLACK, WHITE );
	myCopyArea( XMARGIN, text.bot+1, text.right-1,
                   text.top-CHARHEIGHT-1
		      ,XMARGIN, text.bot+CHARHEIGHT+1 );
	myFilledRectangle( XMARGIN, text.bot+1, text.right-1, CHARHEIGHT);
	pos = lines[ 0 ];
	for( i = 0; i < nLines - 1; i++ )
	  lines[ i ] = lines[ i + 1 ];
	lines[ nLines - 1 ] = pos;
	*pos = '\0';				/* make sure line is empty */
	currLine--;
	yPos = text.bot + 1;
      }
    else
      {
	yPos -= CHARHEIGHT;
	pos = lines[ currLine ];
      }
    xPos = XMARGIN;
  }


/*
 * Clear the text window and place the cursor on the top lin
 */
void ClearTextWindow()
  {
    int  i;
    mySetColors( BLACK, WHITE );
    myFilledRectangle( text.left+1, text.bot+1, text.right-1, text.top-1 );
    myRectangle( text.left, text.bot, text.right, text.top );
    for( i = 0; i < nLines; i++ )
      *lines[ i ] = '\0';
    yPos = text.top - CHARHEIGHT;
    xPos = XMARGIN;
    pos = lines[ 0 ];
    currLine = 0;
  }


/*
 * Redraw the text window
 */
void RedrawText()
  {
    int     i;
    YCoord  y;

    mySetColors( BLACK, WHITE );
    myFilledRectangle( text.left+1, text.bot+1, text.right-1, text.top-1 );
    myRectangle( text.left, text.bot, text.right, text.top );
    y = text.top - CHARHEIGHT;
    for( i = 0; i < nLines; i++, y -= CHARHEIGHT )
     {
	myMoveTo( XMARGIN, y );
	myCharStr( lines[ i ], nCols );
     }
    mySetColors( WHITE, BLACK );	/* redisplay cursor */
    myMoveTo( xPos, yPos );
    myCharStr( mCURSOR, 1 );
  }
