
/*
 *
 * Version identification:
 * @(#)trigger.c	1.1 8/26/91
 *
 */

#ifndef lint
static char rcsid[] = "$Header: trigger.c,v 1.1 86/11/30 03:57:45 salz Exp $";
#endif

#include <stdio.h>
#include "defs.h"


/*
 * Check if any trigger matches a given history entry.
 * Search through the trigger list, if a match is found return 1, otherwise 0.
 */
int TriggerMatch( hist )
  HistRef  hist;
  {
    register int     i, *index;
    register Uint    val;
    register Levels  levels, prevLev;
    TrigEnt  *t;
    
    if( hist == NULL )
	return( 0 );

    levels = hist->levels;
    for( t = trigger.first; t != NULL; t = t->next )
      {
	index = t->index;
	val = t->value;
	switch( t->type )
	  {
	    case ONE_BIT :
		if( levels[ t->index[0] ] == val )
		    return( 1 );
		break;

	    case EQUAL :
		for( i = 0; i < t->nsig; i++, index++ )
		  {
		    if( levels[ *index ] != (val & 1 ) )
			goto nextTrig;
		    val = val >> 1;
		  }
		return( 1 );		/* all bits match */

	    case UorZ :
		for( i = 0; i < t->nsig; i++, index++ )
		  {
		    if( levels[ *index ] != val )
			goto nextTrig;
		  }
		return( 1 );		/* all bits match */

	    case ANY_EQ :
		for( i = 0; i < t->nsig; i++, index++ )
		  {
		    if( levels[ *index ] == val )
			return( 1 );
		    val = val >> 1;
		  }
		break;

	    case ANY_UorZ :
		for( i = 0; i < t->nsig; i++, index++ )
		  {
		    if( levels[ *index ] == val )
			return( 1 );
		  }
		break;

	    case CHANGE :
		if( hist->prev == NULL )
		    goto nextTrig;
		prevLev = hist->prev->levels;

		for( i = 0; i < t->nsig; i++, index++ )
		  {
		    if( levels[ *index ] != prevLev[ *index ] )
			return( 1 );
		  }
		break;
	    default :
		PRINT( "Internal Error in trigger\n" );
	  }
	nextTrig: ;
      }
    return( 0 );			/* no trigger found */
  }


/*
 * Return the time of the next trigger point, starting at hist.
 * If no trigger point is found, return -1.
 */
TimeType NextTrigger( hist )
  HistRef  hist;
  {
    while( hist != NULL )
      {
	if( TriggerMatch( hist ) )
	    return( hist->time );
	hist = hist->next;
      }
    return( -1 );
  }


/*
 * Return the previous trigger point, starting at hist.
 */
TimeType PrevTrigger( hist )
  HistRef  hist;
  {
    while( hist != NULL )
      {
	if( TriggerMatch( hist ) )
	    return( hist->time );
	hist = hist->prev;
      }
    return( -1 );
  }
