
/*
 *
 * Version identification:
 * @(#)scrollbar.c	1.2 11/23/92
 *
 */

#ifndef lint
static char rcsid[]= "$Header: scrollbar.c,v 1.3 87/06/25 17:00:16 rokicki Exp $";
#endif

/*
 * Scrollbar manager.
 */

#include "defs.h"

#define	max( a, b )		( ( (a) > (b) ) ? (a) : (b) )
#define	LastStep		(times.dispStart + times.dispSteps)

static XCoord xLeftArrow[ 3 ];		/* point list for the arrows */
static XCoord xRightArrow[ 3 ];
static YCoord yArrow[ 3 ];
static Box    barPos;			/* Position of the little bar */



InitScrollBar()
  {
    xRightArrow[ 0 ] = trace.right + 6;
    xRightArrow[ 1 ] = trace.right + 6;
    xRightArrow[ 2 ] = trace.right + 10;
    
    yArrow[ 0 ] = scrollbar.bot + 2;
    yArrow[ 1 ] = scrollbar.bot + 10;
    yArrow[ 2 ] = scrollbar.bot + 6;

    xLeftArrow[ 0 ] = trace.left - 5;
    xLeftArrow[ 1 ] = trace.left - 5;
    xLeftArrow[ 2 ] = trace.left - 10;
    
    barPos.bot = scrollbar.bot + SCROLLBARSIZE / 2;
    barPos.top = scrollbar.top - 1;
    UpdateScrollBar();
  }


DrawRightArrow()
  {
    XCoord  x;
    YCoord  bot, top;
    
    x = trace.right;
    bot = scrollbar.bot;
    top = scrollbar.top;
    mySetPattern( clearPat );
    myFilledRectangle( x, bot + 1, scrollbar.right, top );
    myRectangle( x, bot, x + SCROLLBARSIZE, top );

    mySetPattern( solidPat );
    myFilledRectangle( x + 2, bot + 4, x + 5, bot + 8 );
    myTriangle(xRightArrow[0], yArrow[0],
               xRightArrow[1], yArrow[1],
               xRightArrow[2], yArrow[2]) ;
  }



DrawLeftArrow()
  {
    XCoord  x;
    YCoord  bot, top;
    
    x = trace.left;
    bot = scrollbar.bot;
    top = scrollbar.top;
    mySetPattern( clearPat );
    myFilledRectangle( scrollbar.left, bot + 1, x, top );
    myRectangle( x - 12, bot, x, top );

    mySetPattern( solidPat );
    myFilledRectangle( x - 5, bot + 4, x - 2, bot + 8 );
    myTriangle(xLeftArrow[0], yArrow[0],
               xLeftArrow[1], yArrow[1],
               xLeftArrow[2], yArrow[2]) ;
  }


void DrawScrollBar()
  {
    mySetColors( BLACK, WHITE );
    DrawLeftArrow();
    DrawRightArrow();
    UpdateScrollBar();
  }


void DoScrollBar( x, y )
  XCoord  x;
  YCoord  y;
  {
    XCoord    center;
    TimeType  oldStart, oldSteps;

    if((x < trace.left - SCROLLBARSIZE) || ( x > trace.right + SCROLLBARSIZE))
	return;


    mySetColors( WHITE,BLACK );
    
    if( x < trace.left )
      {
	MoveLeft();
      }
    else if( x <= trace.right )
      {
	oldStart = times.dispStart;
	oldSteps = times.dispSteps;
	if( (x >= barPos.left) && (x <= barPos.right) )
	  {
	    if( y > barPos.bot )
	      {
		center = ( barPos.left + barPos.right ) / 2;
		if( x <= center )
		    StretchLeft( x );
		else
		    StretchRight( x );
	      }
	    else
		MoveBar( x );
	    if((oldStart != times.dispStart) || (oldSteps != times.dispSteps))
	      {
		RedrawTraces( times.dispStart, LastStep, 1 );
		RedrawTimes();
		UpdateScrollBar();
	      }
	  }
          else
          {
	    float  tmp;
	    
	    tmp = (float)(times.last-times.first) / (trace.right-trace.left);
	    MoveTo( round( (x - trace.left) * tmp ) );
	  }
      }
    else
      {
	MoveRight();	    /* ( x < trace.right + SCROLLBARSIZE ) */
      }
  }


/*
 * Stretch the scroll bar to the left, up to the current right side.
 */
StretchLeft( x )
  XCoord  x;
  {
    XCoord      xmax;
    XEvent rep ;
    XMotionEvent *xke ;
    float       tmp;
    TimeType	maxTime;
    int newx ;

    xke = (XMotionEvent *)&rep ;
    maxTime = max( times.last, LastStep );
    if( maxTime <= times.first )
	return;
    tmp = (float)(maxTime - times.first) / (trace.right - trace.left);
    xmax = barPos.right - round( 2.0/tmp );
    mySetRendering( INVERT );

    myFilledRectangle( x, barPos.bot, barPos.right, barPos.top );


    while (1)
      {
        XNextEvent(display,&rep) ;
        if (rep.type == ButtonRelease)  break ;
        else if (rep.type == MotionNotify) {
          newx = xke->x ;
          myFilledRectangle( x, barPos.bot, barPos.right, barPos.top );
          x = newx ;
          if( x < trace.left )
	    x = trace.left;
          else if( x > xmax )
	    x = xmax;
          myFilledRectangle( x, barPos.bot, barPos.right, barPos.top
                            );
        }
      }

    myFilledRectangle( x, barPos.bot, barPos.right, barPos.top );
    barPos.left = x;
    times.dispStart = round( (barPos.left - trace.left) * tmp ) + times.first;
    times.dispSteps = round( (barPos.right - barPos.left) * tmp );
    if( times.dispSteps % 2 != 0 )
	times.dispSteps++;

    mySetRendering( PAINTFGBG );
  }



/*
 * Stretch the scroll bar to the right, up to the current left side.
 */
StretchRight( x )
  XCoord  x;
  {
    XCoord      xmin;
    XEvent rep ;
    XMotionEvent *xke ;
    float       tmp;
    TimeType	maxTime;
    int newx ;
    xke = (XMotionEvent *)&rep ;

    maxTime = max( times.last, LastStep );
    if( maxTime <= times.first )
	return;
    tmp = (float)(maxTime - times.first) / (trace.right - trace.left);
    xmin = barPos.left + round( 2.0/tmp );
    mySetRendering( INVERT );
    myFilledRectangle( barPos.left, barPos.bot, x, barPos.top );


    while (1)
      {
        XNextEvent(display,&rep) ;
        if (rep.type == ButtonRelease)  break ;
        else if (rep.type == MotionNotify) {
          newx = xke->x ;
          myFilledRectangle( barPos.left, barPos.bot, x, barPos.top );
          x = newx ;
          if( x < xmin )
	    x = xmin;
          else if( x > trace.right )
	    x = trace.right;
          myFilledRectangle( barPos.left, barPos.bot, x, barPos.top );
        }
      }

    myFilledRectangle( barPos.left, barPos.bot, x, barPos.top );
    barPos.right = x;
    times.dispStart = round( (barPos.left - trace.left) * tmp ) + times.first;
    times.dispSteps = round( (barPos.right - barPos.left) * tmp );
    if( times.dispSteps % 2 != 0 )
	times.dispSteps++;

    mySetRendering( PAINTFGBG );
  }



/*
 * Move the scrollbar left or right, always within the scrollbar bounds.
 */
MoveBar( x )
  XCoord  x;
  {
    XEvent rep ;
    XMotionEvent *xke ;
    XCoord      width, handle;
    YCoord      bot, top;
    float       tmp;
    TimeType	maxTime;
    int newx ;

    xke = (XMotionEvent *)&rep ;
    maxTime = max( times.last, LastStep );
    if( maxTime <= times.first )
	return;
    top = barPos.top;
    bot = barPos.bot;
    width = barPos.right - barPos.left;
    handle = x - barPos.left;
    mySetRendering( INVERT );
    myFilledRectangle( x - handle, bot, x - handle + width, top );

    while (1)
      {
        XNextEvent(display,&rep) ;
        if (rep.type == ButtonRelease)  break ;
        else if (rep.type == MotionNotify) {
          newx = xke->x ;
          myFilledRectangle( x - handle, bot, x - handle + width, top );
          x = newx ;
          if( x - handle + width > trace.right )
            {
              if( x > trace.right )
		x = trace.right;
              handle = x - (trace.right - width);
            }
          else if( x - handle < trace.left )
            {
              if( x < trace.left )
		x = trace.left;
              handle = x - trace.left;
            }
          myFilledRectangle( x - handle, bot, x - handle + width, top
                            );
        }
      }

    myFilledRectangle( x - handle, bot, x - handle + width, top );    
    barPos.left = x - handle;
    barPos.right = x - handle + width;

    tmp = (float)(maxTime - times.first) / (trace.right - trace.left);
    times.dispStart = round( (barPos.left - trace.left) * tmp ) + times.first;
    times.dispSteps = round( (barPos.right - barPos.left) * tmp );

    mySetRendering( PAINTFGBG );
  }


/*
 * Update and redraw the scrollbar.
 */
void UpdateScrollBar()
  {
    float  tmp;

    mySetColors( BLACK, WHITE );
    if( times.last == times.first  )
      {
	barPos.left = trace.left;
	barPos.right = trace.right;
      }
    else
      {
        TimeType  maxTime;

	maxTime = max( times.last, LastStep );
	tmp = (float)(trace.right - trace.left) / (maxTime - times.first);
	barPos.left = trace.left + round( tmp*(times.dispStart-times.first) );
	barPos.right = barPos.left + round( tmp * times.dispSteps );
      }
    mySetPattern( stipplePat );
    myFilledRectangle( trace.left, scrollbar.bot, trace.right, scrollbar.top );
    mySetPattern( clearPat );
    myRectangle( trace.left, scrollbar.bot, trace.right, scrollbar.top );
    myFilledRectangle( barPos.left, barPos.bot, barPos.right, barPos.top );
    myRectangle( barPos.left, barPos.bot, barPos.right, barPos.top );
  }



MoveLeft()
  {
    TimeType  t;

    if( times.first < 0 )
	return;
    t = times.dispStart - times.dispSteps / 2;

    if( t < times.first )
	t = times.first;

    if( t == times.dispStart )
	return;

    times.dispStart = t;
    RedrawTraces( t, LastStep, 1 );
    RedrawTimes();
    UpdateScrollBar();
  }


MoveRight()
  {
    TimeType  t;

    if( times.first < 0 )
	return;
    t = times.dispStart + times.dispSteps / 2;

    if( (t > times.last) || (t == times.dispStart) )
	return;
    
    times.dispStart = t;
    RedrawTraces( t, LastStep, 1 );
    RedrawTimes();
    UpdateScrollBar();
  }
