
/*
 *
 * Version identification:
 * @(#)parser.h	1.2 11/23/92
 *
 */

#define parserRCSID "$Header: parser.h,v 1.1 86/11/30 03:58:19 salz Exp $"

/*
 * Definitions for the command parser
 */

typedef enum
  {
    Noop,
    MovLeft,
    MovRight,
    MovBeg,
    MovEnd,
    ZoomIN,
    ZoomOUT,
    SeeAll
  } Options;

typedef struct
  {
    char     *cmd;			/* command name for lookup */
    char     *help;			/* help string for command */
    void      (*func)();		/* function to call on command */
    Options  opt;			/* option selected by command */
  } LookupTable;

extern LookupTable 	CmdTable[];
extern LookupTable	Positions[];
extern LookupTable	ZoomDir[];

extern LookupTable	*LookupCmd();
extern int		MatchStr();
extern int		GetArgs();
extern int		MatchNames();

extern void nullF();			/* dummy null function */
extern void CmdAdd();
extern void CmdAuto();
extern void CmdBase();
extern void CmdDelete();
extern void CmdExec();
extern void CmdCont();
extern void CmdClear();
extern void CmdFirst();
extern void CmdLast();
extern void CmdList();
extern void CmdLines();
extern void CmdHelp();
extern void CmdMove();
extern void CmdMovetrace();
extern void CmdNext();
extern void CmdPrevious();
extern void CmdPrint();
extern void CmdQuit();
extern void CmdRemove();
extern void CmdRedraw();
extern void CmdReclaim();
extern void CmdRead();
extern void CmdStatus();
extern void CmdStop();
extern void CmdTrace();
extern void CmdWidth();
extern void CmdWhatis();
extern void CmdWrite();
extern void CmdZoom();
