
/*
 *
 * Version identification:
 * @(#)mem.c	1.2 11/23/92
 *
 */

#ifndef lint
static char rcsid[] = "$Header: mem.c,v 1.1 86/11/30 03:57:32 salz Exp $";
#endif

/*
 *	Next-fit storage allocation mechanism
 *
 *	Algorithm and variable names stolen from Knuth V1, p 437,
 *		with suggested modifications from Exercise 2.5.6.
 *
 *	Storage is manipulated in terms of UNITs, the amount needed
 *		to store a pointer and length.  Requests are always
 *		rounded up to multiples of UNITs.
 */

#include "mem.h"

char* sbrk();

#define	NULL		0		/* for addresses */
#define	MINSBRK		4096		/* minimum sbrk = 4096 MEMUNITs */

/*
 *	free list is kept in address order
 *	avail is a dummy header that points to first free element
 *	rover is pointer into free list
 */

static MemElement avail;
static MemElement *rover = &avail;


/*
 * Returns a pointer to n WORDS of storage
 */
char *Malloc( n )
  int  n;
  {
    register MemElement  *p, *q;
    register int         size;
    MemElement           *r;
    int                  increment;
    int                  repeat;

    Start :
    if( n <= 0 )
	return( NULL );
    size = (n + MEMUNIT - 1) / MEMUNIT;
    if( rover == NULL )
	rover = &avail;
    q = rover;
    p = q->link;

    repeat = 0;
    for(;;)			    /* outer loop executed at most twice */
      {
        /* search for a block large enough */
        while( (p != NULL ) && ( p->size < size) )
	  {
	    q = p;
	    p = p->link;
    	  }

        if( (p != NULL) || repeat )
	    break;			/* done, found it or 2nd time */

	q = &avail;		 /* first time, one more chance */
	p = q->link;
	repeat = 1;
      }

    if( p == NULL )	        /* out of memory, get some more */
      {
	increment = (size < MINSBRK) ? MINSBRK : size;
	r = (MemElement *) sbrk( increment * MEMUNIT );
	if( (int) r == -1 )
	    return( NULL );

	Mfree( r, increment * MEMUNIT );		/* release it */

	goto Start;		/* call self recursively to allocate memory */
      }
    else
      {
	if( p->size == size )
	  {
	    /* found one of right size. remove it */
	    q->link = p->link;
	  }
	else if( p->size > size )
	  {
	    /* found one too big. take part of it */
	    r = p + size;    /* remaining free area */
	    q->link = r;
	    r->link = p->link;
	    r->size = p->size - size;
	  }
	rover = q->link;
      }
    return( (char *) p );
  }


/*
 * Mfree( p0, n ) adds the block of n bits pointed to by p0 to the
 * free list
 */
void Mfree( p0, n )
  MemElement *p0;
  int n;
  {
    register MemElement *p, *q, *r;

    n = (n + MEMUNIT - 1) / MEMUNIT;
    q = &avail;
    r = p0;
    p = q->link;

    while( (p != NULL) && (p < r) )	/* search for the right place */
      {
	q = p;
	p = p->link;
      }
	/* this is where it should go */
	/* note: since NULL = 0, if p = NULL, p != r + n */

    if( p == r + n )			/* new block abuts p, consolidate */
      {
	n += p->size;
	r->link = p->link;
      }
    else				/* does not abut, just connect */
      {
	r->link = p;
      }

    if( r == q + q->size )		/* new block abuts q, consolidate */
      {
	q->size += n;
	q->link = r->link;
      }
    else				/* does not abut, just connect */
      {
	q->link = r;
	r->size = n;
      }
    rover = q;			/* start searching here next time */
  }
