
/*
 *
 * Version identification:
 * @(#)ipc.h	1.1 8/26/91
 *
 */

#define ipcRCSID "$Header: ipc.h,v 1.1 86/11/30 03:58:16 salz Exp $"

/*
 * Inter-Process Communication definitions
 */

#define MAXDATASIZE	250	/* max number of inputs */

typedef enum
  {
    ADDSIGNAL,			/* Add new signal to net list (at end) */
    DELETESIGNAL,		/* Delete signal from net list */
    MOVESIGNAL,			/* Rename a signal on the net list */
    SIGVALUES,			/* New signal values */
    STOP,			/* Stop the simulator */
    CONT,			/* Restart the simulator */
    IPC_OK,			/* Generic return value for Sends */
    IPC_ERR,			/* Communication error */
  } MsgType;


typedef struct
  {
    MsgType  type;
    int      length;		/* data size, that follows the header */
  } Header;


typedef struct
  {
    Header   header;
    char     data[ MAXDATASIZE ];
  } Message;


typedef struct			/* format for rename signal message */
  {
    int   signum;			/* signal number */
    int   len;				/* length of name + 1 */
    char  name[ MAXDATASIZE ];		/* new name */
  } RenSigMsg;

typedef struct		/* format for delete signal message */
  {
    int  signum;			/* signal number to delete */
  } DelSigMsg;

typedef struct			/* format for add signal message */
  {
    int   signum;			/* signal that it replaces */
    int   len;				/* length of the name + 1 */
    char  name[ MAXDATASIZE ];		/* name of new signal */
  } AddSigMsg;


	/* Exports */

extern MsgType    ipc_Receive();
extern MsgType    ipc_Send();
