
/*
 *
 * Version identification:
 * @(#)graphics.c	1.2 11/23/92
 *
 */

/*
 *   This is the primary interface to the windowing systems.  The types
 *   of some of the arguments might not match, so be careful.
 */
#include <stdio.h>
#include "defs.h"
#include <X11/cursorfont.h>
#include "graphics.h"


#include "Bitmaps/gray"
#include "Bitmaps/xpat"
#include "Bitmaps/left_arrows"
#include "Bitmaps/right_arrows"
#include "Bitmaps/left_curs"
#include "Bitmaps/left_mask"
#include "Bitmaps/right_curs"
#include "Bitmaps/right_mask"
#include "Bitmaps/chk"
#include "Bitmaps/iconbox"
#include "Bitmaps/sizebox"
#include "Bitmaps/select"

#define or ||
#define and &&
#define not !

#define SWAP(TYPE, A, B)              \
{                          \
  register TYPE TMP;       \
   TMP = (A);              \
   (A) = (B);              \
   (B) = TMP;              \
 } \


extern int descent;

PIX       pix;
COL       colors;
CURS      cursors;

char   tops_bits[3][2] = { 0x5, 0x7, 0x1, 0x3, 0x4, 0x6 };
char   bots_bits[3][2] = { 0x7, 0x5, 0x3, 0x1, 0x6, 0x4 };


/* static int rendering = GXcopy ;*/
static GC curgc;
static XGCValues      curgcv;
static unsigned long  curmask;

/* static int fgcolor, bgcolor ; */
static int sfgcolor, sbgcolor ;
static int Xx, Xy ;

static short stipple_map[16] = {
   0x0000, 0x2222, 0x7777, 0x2222,
   0x0000, 0x4444, 0xeeee, 0x4444,
   0x0000, 0x8888, 0xdddd, 0x8888,
   0x0000, 0x1111, 0xbbbb, 0x1111} ;
static short diags_map[16] = {
   0x1111, 0x1111, 0x2222, 0x2222,
   0x4444, 0x4444, 0x8888, 0x8888,
   0x1111, 0x1111, 0x2222, 0x2222,
   0x4444, 0x4444, 0x8888, 0x8888} ;
static short black_map[16] = {
   0xffff, 0xffff, 0xffff, 0xffff,
   0xffff, 0xffff, 0xffff, 0xffff,
   0xffff, 0xffff, 0xffff, 0xffff,
   0xffff, 0xffff, 0xffff, 0xffff} ;
static short white_map[16] = {
   0x0000, 0x0000, 0x0000, 0x0000,
   0x0000, 0x0000, 0x0000, 0x0000,
   0x0000, 0x0000, 0x0000, 0x0000,
   0x0000, 0x0000, 0x0000, 0x0000} ;
static Pixmap black_pixmap, white_pixmap, stipple_pixmap, diag_pixmap ;
static Pixmap cur_pixmap ;




#define	DEFL_GEOM	0
#define	DEFL_BG		1
#define	DEFL_FG		2
#define	DEFL_RV		3
#define	DEFL_HIGL	4
#define	DEFL_TRCOLOR	5
#define	DEFL_BANN_BG	6
#define	DEFL_BANN_FG	7
#define	DEFL_BDRCOLOR	8
#define	DEFL_FONT	9
#define	DEFL_BDRWIDTH	10


typedef struct
  {
    char  *name;
    char  *defl;
  } Assoc;


	Assoc assoc[] =
  {
    { "geometry",	"=1000x300+0+0" },
    { "background",	"black" },
    { "foreground",	"white" },
    { "reverseVideo",	"off" },
    { "highlight",	"red" },
    { "traceColor",	"black" },
    { "bannerBg",	"black" },
    { "bannerFg",	"white" },
    { "borderColor",	"black" },
    { "font",		"6x13" },
    { "borderWidth",	"3" },
  };


char  *thor = "thor";

 char *GetXDefault( key )
  int  key;
  {
    char         *val;

    val = XGetDefault( display, thor, assoc[ key ].name );
    return( (val != NULL) ? val : assoc[ key ].defl );
  }


int IsDefault( key, val )
  int   key;
  char  *val;
  {
    if( assoc[ key ].defl == val )
	return( TRUE );
    return( (strcmp( assoc[ key ].defl, val ) == 0) ? TRUE : FALSE );
  }


char *ProgDefault( key )
  {
    return( assoc[ key ].defl );
  }


#define	SAME_COLOR( A, B )	\
    ( (A).red == (B).red and (A).green == (B).green and (A).blue == (B).blue )

int GetColor( key, colors, ndefined )
  int     key;
  XColor  colors[];
  int     ndefined;
  {
    char      *s;
    XColor    *color;
    int       i;
    Colormap  cmap = DefaultColormapOfScreen( screen );

    color = &colors[ndefined];
    s = GetXDefault( key );
    if( XParseColor( display, cmap, s, color ) == 0 )
      {
	if( IsDefault( key, s ) )
	    return( FALSE );

	fprintf( stderr, "server doesn't know color '%s'", s );
	s = ProgDefault( key );
	if( XParseColor( display, cmap, s, color ) == 0 )
	  {
	    fprintf( stderr, " or '%s'\n", s );	    /* weird, should not be */
	    return( FALSE );
	  }
	fprintf( stderr, "using '%s' instead\n", s );
      }
    for( i = 0; i < ndefined; i++ )
      {
	if( SAME_COLOR( *color, colors[i] ) )
          {
            color->pixel = colors[i].pixel;
            return( TRUE );
          }
      }
    return( (XAllocColor( display, cmap, color ) == 0) ? FALSE : TRUE );
  }

#define	BACKGROUND_COLOR	0
#define	FOREGROUND_COLOR	1
#define	TRACE_COLOR		2
#define	HIGHLIGHT_COLOR		3
#define	BANNER_BG_COLOR		4
#define	BANNER_FG_COLOR		5
#define	BORDER_COLOR		6
#define	MAX_NCOLORS		7

 void SetColors()
  {
    XColor    coldef[ MAX_NCOLORS ];

    if( PlanesOfScreen( screen ) < 2 )
	goto mono;

    if( not GetColor( DEFL_BG, coldef, BACKGROUND_COLOR ) )
	goto mono;
    colors.black = coldef[ BACKGROUND_COLOR ].pixel;

    if( not GetColor( DEFL_FG, coldef, FOREGROUND_COLOR ) )
	goto mono;
    colors.white = coldef[ FOREGROUND_COLOR ].pixel;

    if( GetColor( DEFL_TRCOLOR, coldef, TRACE_COLOR ) )
	colors.traces = coldef[ TRACE_COLOR ].pixel;
    else
	colors.traces = colors.white;

    if( GetColor( DEFL_HIGL, coldef, HIGHLIGHT_COLOR ) )
      {
	colors.color_hilite = TRUE;
	colors.hilite = coldef[ HIGHLIGHT_COLOR ].pixel;
	if( ((colors.black | colors.hilite) == colors.hilite and
	 (colors.traces & ~colors.hilite) == colors.traces ) )
	    colors.disj = 1;
	else if( (colors.black & ~colors.hilite) == colors.hilite and
	 (colors.traces | colors.hilite) == colors.traces )
	    colors.disj = 2;
	else
	    colors.disj = 0;
      }
    else
      {
	colors.disj = 0;
	colors.hilite = colors.black;
	colors.color_hilite = FALSE;
	colors.mono = TRUE;
      }

    if( GetColor( DEFL_BANN_BG, coldef, BANNER_BG_COLOR ) )
	colors.banner_bg = coldef[ BANNER_BG_COLOR ].pixel;
    else
	colors.banner_bg = colors.white;

    if( GetColor( DEFL_BANN_FG, coldef, BANNER_FG_COLOR ) )
	colors.banner_fg = coldef[ BANNER_FG_COLOR ].pixel;
    else
	colors.banner_fg = colors.black;

    if( GetColor( DEFL_BDRCOLOR, coldef, BORDER_COLOR ) )
	colors.border = coldef[ BORDER_COLOR ].pixel;
    else
	colors.border = colors.black;

    return;

  mono:
    colors.mono = TRUE;
    colors.color_hilite = FALSE;
    colors.disj = 0;
    colors.black = BlackPixelOfScreen( screen );
    colors.white = WhitePixelOfScreen( screen );
    if( strcmp( GetXDefault( DEFL_RV ), "on" ) == 0 )
	SWAP( Pixel, colors.black, colors.white );
    colors.traces = colors.banner_bg = colors.white;
    colors.hilite = colors.banner_fg = colors.border = colors.black;
  }


#define MakeBitmap( D, W, H )	\
 XCreateBitmapFromData( display, DefaultRootWindow( display ), D, W, H );


#define MakePixmap( D, W, H, FG, BG )	\
 XCreatePixmapFromBitmapData( display, DefaultRootWindow( display ), \
  D, W, H, FG, BG, DefaultDepthOfScreen( screen ) )


 void InitBitmaps()
  {
    int     i;


    black_pixmap = MakePixmap(black_map, 16, 16, colors.black, colors.white) ;

    white_pixmap = MakePixmap(white_map, 16, 16, colors.black, colors.white) ;

    stipple_pixmap = MakePixmap(stipple_map, 16, 16, colors.black, colors.white) ;

    diag_pixmap = MakePixmap(diags_map, 16, 16, colors.black, colors.white) ;
    cur_pixmap = black_pixmap ;

    pix.gray = MakePixmap( gray_bits, gray_width, gray_height,
     colors.white, colors.black );

    pix.xpat = MakePixmap( xpat_bits, xpat_width, xpat_height, colors.traces,
     colors.black );

    pix.left_arrows = MakePixmap( left_arrows_bits, left_arrows_width,
     left_arrows_height, colors.black, colors.white );

    pix.right_arrows = MakePixmap( right_arrows_bits, right_arrows_width,
     right_arrows_height, colors.black, colors.white );

    for( i = 0; i < 3; i++ )
      {
	pix.tops[i] = MakePixmap( tops_bits[i], 3, 2,
	 colors.traces, colors.black);
	pix.bots[i] = MakePixmap( bots_bits[i], 3, 2,
	 colors.traces, colors.black);
      }

    pix.chk = MakePixmap( chk_bits, chk_width, chk_height, colors.black,
     colors.white );

    pix.iconbox = MakePixmap( iconbox_bits, iconbox_width, iconbox_height,
     colors.banner_fg, colors.banner_bg );

    pix.sizebox = MakePixmap( sizebox_bits, sizebox_width, sizebox_height,
     colors.banner_fg, colors.banner_bg );

    pix.select = MakePixmap( select_bits, select_width, select_height,
     colors.banner_fg, colors.banner_bg );


  }


 Cursor MakeCursor( fg, bg, curs, mask, w, h, x, y )
  XColor  *fg, *bg;
  char    *curs, *mask;
  int     w, h;
  {
    Pixmap  pcurs, pmask;
    Cursor  cu;

    pcurs = MakeBitmap( curs, w, h );
    pmask = MakeBitmap( mask, w, h );
    cu = XCreatePixmapCursor( display, pcurs, pmask, fg, bg, x, y );
    XFreePixmap( display, pcurs );
    XFreePixmap( display, pmask );
    return( cu );
  }


 void InitCursors()
  {
    XColor  cols[2];

    cols[0].pixel = colors.white;
    cols[1].pixel = colors.black;
    XQueryColors ( display, DefaultColormapOfScreen( screen ), cols, 2 );
#define	XWHITE	(&cols[0])
#define	XBLACK	(&cols[1])

    cursors.deflt = XCreateFontCursor( display, XC_left_ptr );
    XRecolorCursor( display, cursors.deflt, XWHITE, XBLACK );

    cursors.left = MakeCursor( XWHITE, XBLACK, left_curs_bits, left_mask_bits,
     left_curs_width, left_curs_height, left_curs_x_hot, left_curs_y_hot );

    cursors.right = MakeCursor( XWHITE, XBLACK, right_curs_bits,
     right_mask_bits, right_curs_width, right_curs_height, right_curs_x_hot,
     right_curs_y_hot );

    cursors.timer = XCreateFontCursor( display, XC_watch );
    XRecolorCursor( display, cursors.timer, XBLACK, XWHITE );

    cursors.move = XCreateFontCursor( display, XC_fleur );
    XRecolorCursor( display, cursors.timer, XBLACK, XWHITE );

  }




 void InitGraphics( font )
  Font  font;
  {
    XGCValues      gcv;
    unsigned long  mask;
    Window         root;

    SetColors();
    InitBitmaps();
    InitCursors();
    
    root = RootWindowOfScreen( screen );

    mask = 0;
    gcv.foreground = colors.white;			mask |= GCForeground;
    gcv.background = colors.black;			mask |= GCBackground;
    gcv.line_width = 1;					mask |= GCLineWidth;
    gcv.font = font;					mask |= GCFont;
    curgc =  XCreateGC( display, root, mask, &gcv );
  }




mySetRendering(r)
int r ;
{
      if (r==(int)PAINTFGBG) {
        curmask = GCFunction | GCForeground | GCBackground;
        curgcv.function = GXcopy;
        curgcv.foreground = sfgcolor;
        curgcv.background = sbgcolor;
        XChangeGC( display, curgc, curmask, &curgcv);
/*       rendering = GXcopy ;
         fgcolor = sfgcolor ;
         bgcolor = sbgcolor ;
*/
      } else {
        curmask = GCFunction | GCForeground | GCBackground;
        curgcv.function = GXxor;
        curgcv.foreground = curgcv.background = sfgcolor ^ sbgcolor;
        XChangeGC( display, curgc, curmask, &curgcv);
/*         rendering = GXxor ;
         fgcolor = bgcolor = sfgcolor ^ sbgcolor ; */
      }
    }

mySetColors(fg, bg)
int fg, bg ;
{
     curmask = GCTile | GCForeground | GCBackground;
      curgcv.foreground = sfgcolor = (fg == BLACK ? colors.black : colors.white ) ;
      curgcv.background = sbgcolor = (bg == BLACK ? colors.black : colors.white ) ;
      curgcv.tile = (bg == BLACK ? black_pixmap : white_pixmap) ;
     XChangeGC( display, curgc, curmask, &curgcv);

/*      fgcolor = sfgcolor = (fg == BLACK ? xblack : xwhite ) ;
      bgcolor = sbgcolor = (bg == BLACK ? xblack : xwhite ) ;
      cur_pixmap = (bg == BLACK ? black_pixmap : white_pixmap) ;
*/
}

mySetPattern(p)
int p ;
{
      switch(p) {
case clearPat:
         curgcv.tile = white_pixmap ;
         break ;
case solidPat:
         curgcv.tile = black_pixmap ;
         break ;
case stipplePat:
         curgcv.tile = stipple_pixmap ;
         break ;
case majorDiagPat:
         curgcv.tile = diag_pixmap ;
         break ;
       }
      curmask = GCTile ;
     XChangeGC( display, curgc, curmask, &curgcv);
    }



myCopyArea(x1, y1, x2, y2, xdest, ydest)
int x1, y1, x2, y2, xdest, ydest ;
{
      y1 = YWINDOWSIZE - y1 ;
      y2 = YWINDOWSIZE - y2 ;
      ydest = YWINDOWSIZE - ydest ;
      if (y1 > y2) {
         int t ;

         t = y1 ;
         y1 = y2 ;
         y2 = t ;
         ydest -= (y2 - y1) ;
      }
      XCopyArea(display, window, window, curgc, x1, y1,  x2-x1+1,
                y2-y1+1, xdest, ydest) ;
}

myMoveTo(x, y)
int x, y ;
{
/*      Xx = x ; Xy = YWINDOWSIZE - y - metrics.charHeight - 1 ;*/
      Xx = x ; Xy = YWINDOWSIZE - y; 

}

myCharStr(s, len)
char *s ;
int len ;
{
      int t = strlen(s) ;
      if (t < len)
         len = t ;
      StrLeft(window, s, len, Xx, Xy, curgc);
}

myFilledRectangle(x1, y1, x2, y2)
int x1, y1, x2, y2 ;
{
      y1 = YWINDOWSIZE - y1 ;
      y2 = YWINDOWSIZE - y2 ;
      XSetFillStyle(display,curgc,FillTiled);
      XFillRectangle(display, window, curgc, x1, y2, x2-x1+1,
                     y1-y2+1);
      XSetFillStyle(display,curgc,FillSolid);
      
/*      XTileFill(window, x1, y2, x2-x1+1, y1-y2+1, cur_pixmap, 0, 
         rendering, AllPlanes) ;*/
}

myLine(x1, y1, x2, y2)
int x1, y1, x2, y2 ;
{
      y1 = YWINDOWSIZE - y1 ;
      y2 = YWINDOWSIZE - y2 ;
      XDrawLine(display, window, curgc, x1, y1, x2, y2);
/*      XLine(window, x1, y1, x2, y2, 1, 1, fgcolor, rendering, AllPlanes) ;*/
}

myRectangle(x1, y1, x2, y2)
int x1, y1, x2, y2 ;
{
      y1 = YWINDOWSIZE - y1 ;
      y2 = YWINDOWSIZE - y2 ;
      XDrawLine(display, window, curgc, x1, y1, x1, y2) ;
      XDrawLine(display, window, curgc, x1, y1, x2, y1);
      XDrawLine(display, window, curgc, x1, y2, x2, y2);
      XDrawLine(display, window, curgc, x2, y1, x2, y2);
}

myTriangle(x1, y1, x2, y2, x3, y3)
int x1, y1, x2, y2, x3, y3 ;
{
   myLine(x1, y1, x2, y2) ;
   myLine(x2, y2, x3, y3) ;
   myLine(x3, y3, x1, y1) ;
}

