
/*
 *
 * Version identification:
 * @(#)exec.c	1.2 11/23/92
 *
 */

#ifndef lint
static char rcsid[] = "$Header: exec.c,v 1.4 87/05/05 13:35:46 rokicki Exp $";
#endif
/*
 * User commands to the analyzer
 */


#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "defs.h"
#include "parser.h"

void exit();
int sscanf(), atoi();

static int  sigList[ MAXINPUTS ];
void MoveTo(), DisplayTrigger();

void Exec( line )
  char   *line;
  {
    int		 nargs;
    char	 *(args[ 40 ] );
    LookupTable	 *cmd;
    
    nargs = GetArgs( line, args );
    if( nargs == 0 )
	return;
    cmd = LookupCmd( args[0], CmdTable );
    if( cmd == NULL )
      {
	PRINT( "Unknown Command\n" );
	return;
      }
    if( cmd->cmd == NULL )		/* ambiguous command */
	return;

    (cmd->func)( nargs - 1, &(args[ 1 ]) );
  }


#define	RETURN( msg )	{ PRINT( msg ); return; }

void CmdAdd( narg, args )
  int   narg;
  char  *args[];
  {
    int       nsig, base, nbits, ndigits, len;
    TraceEnt  *t;
    
    if( traces.numTraces >= MAXTRACES )
	RETURN( "sorry, too many traces\n" )
    if( narg < 1 )
	RETURN( "Add what ?\n" )
    nsig = MatchNames( args, narg, inputs.names, inputs.numInputs, sigList );
    if( nsig == 0 )
	RETURN( "No such signals\n" )
    if( nsig > MAXBUSSIZE )
	RETURN( "sorry: maximum bus width is 32 bits\n" )
    if( nsig > 1 )
      {
	if( sscanf( args[ narg - 1 ], "b=%d", &base ) == 1 )
	  {
	    switch( base )
	      {
		case 2 :
		    nbits = 1;
		    break;
		case 8 :
		    nbits = 3;
		    break;
		case 16 :
		    nbits = 4;
		    break;
		default :
		    PRINT( "Illegal base, try one of 2, 4, or 16\n" );
		    return;
	      }
	  }
	else				/* no base specified, use default */
	    nbits = DEFBITS;
      }
    else
	nbits = 1;			/* one signal */

    ndigits = ( nsig + nbits - 1 ) / nbits;

    t = &(traces.traces[ traces.numTraces++ ]);
    t->bits = nbits;
    t->nsig = nsig;
    for( nbits = 0; nbits < nsig; nbits++ )
	t->signals[ nbits ] = sigList[ nbits ];
    t->sameRoot = IsSameRoot( sigList, nsig );
    
    GetSignalPos();

    len = MaxTraceName();
    if( (ndigits > traces.maxDigits) || (len > traces.maxName) )
      {
	if( len > traces.maxName )
	    traces.maxName = len;
	if( ndigits > traces.maxDigits )
	    traces.maxDigits = ndigits;
	SetWindowParms();
	DrawScrollBar();
	RedrawTimes();
      }
    RedrawNames();
    RedrawTraces( times.dispStart, times.dispStart + times.dispSteps, 1 );
    DrawCursVal();
    if( traces.dispTraces < traces.numTraces )
	PRINT( "Not enough vertical space, try enlarging the window\n" );
  }



void CmdAuto( narg, args )
  int   narg;
  char  *args[];
  {
    char  *s;

    if( narg == 0 )
      {
	if( trigger.autostop )
	    PRINT( "auto stop is ON\n" );
	else
	    PRINT( "auto stop is OFF\n" );
      }
    else
      {
	for( s = args[0]; *s != '\0'; s++ )
	    *s |= 0x20;
	if( !strcmp( args[ 0 ], "on" ) )
	    trigger.autostop = 1;
	else if( !strcmp( args[ 0 ], "off" ) )
	    trigger.autostop = 0;
	else
	  {
	    PRINT( args[ 0 ] );
	    PRINT( "? unknown option\n" );
	  }
      }
  }


void CmdBase( narg, args )
  int   narg;
  char  *args[];
  {
    int       tnum, base, nbits, maxDigits;
    TraceEnt  *t;

    if( narg != 2 )
	RETURN( "Missing arguments\n" );
    tnum = atoi( args[ 0 ] ) - 1;
    base = atoi( args[ 1 ] );
    if( (tnum < 0) || (tnum >= traces.numTraces) )
	RETURN( "No such trace number\n" );
    switch( base )
      {
	case 2 :
	  nbits = 1;
	  break;
	case 8 :
	  nbits = 3;
	  break;
	case 16 :
	  nbits = 4;
	  break;
	default :
	  PRINT( "Illegal base, Try 2, 4, or 16\n" );
	  return;
      }
    t = &( traces.traces[ tnum ] );
    if( (t->nsig == 1) || (t->bits == nbits) )
	return;					/* done, no change needed */
    t->bits = nbits;
    maxDigits = MaxTraceDigits();
    if( maxDigits != traces.maxDigits )
      {
	traces.maxDigits = maxDigits;
	SetWindowParms();
	DrawScrollBar();
	RedrawTimes();
      }
    RedrawTraces( times.dispStart, times.dispStart + times.dispSteps, 1 );
    DrawCursVal();
  }

void CmdRemove( narg, args )
  int   narg;
  char  *args[];
  {
    int  tnum;
    
    if( narg == 0 )
	RETURN( "Remove which trace?\n" );
    tnum = atoi( args[ 0 ] );
    if( (tnum < 1) || (tnum > traces.numTraces) )
      {
	char  errMsg[ 50 ];
	
	sprintf( errMsg, "No such trace. Try [1-%d].\n", traces.numTraces );
	PRINT( errMsg );
	return;
      }
    DeleteTrace( tnum );
  }


void CmdCont( narg, args )	/* ARGSUSED */
  int   narg;
  char  *args[];
  {
    switch( windowState.simulStatus )
      {
	case RUNNING :
	    PRINT( "Simulator is already running!\n" );
	    break;
	case STOPPED :
	    windowState.restart = 1;
	    break;
	case STOP_NO_MEM :
	    PRINT( "Can't continue, I'm out of memory. Try reclaim\n" );
	    break;
	case DEAD :
	    PRINT( "Can't continue, simulator is dead\n" );
	    break;
      }
  }

void CmdClear( narg, args )	/* ARGSUSED */
  int   narg;
  char  *args[];
  {
    ClearTextWindow();
  }


void CmdExec( narg, args )
  int   narg;
  char  *args[];
  {
    FILE  *fd;
    char  line[ 256 ];
    char  *prompt;

    if( narg == 0 )
	RETURN( "Missing filename\n" );
    fd = fopen( args[0], "r" );
    if( fd == NULL )
	RETURN( "can't open file!\n" );
    prompt = args[ 0 ];
    strcat( prompt, " >" );
    while( fgets( line, sizeof( line ), fd ) != NULL )
      {
	PRINT( prompt );
	PRINT( line );
	Exec( line );
      }
  }


void CmdFirst( narg, args )	/* ARGSUSED */
  int   narg;
  char  *args[];
  {
    TimeType  time;
    
    time = NextTrigger( GetHist( times.first ) );
    if( time < 0 )
	PRINT( "Trigger not found\n" );
    else
	MoveTo( time );
  }


void CmdLast( narg, args )	/* ARGSUSED */
  int   narg;
  char  *args[];
  {
    TimeType  time;

    time = PrevTrigger( GetHist( times.last ) );
    if( time < 0 )
	PRINT( "Trigger not found\n" );
    else
	MoveTo( time );
  }



void CmdList( narg, args )	/* ARGSUSED */
  int   narg;
  char  *args[];
  {
    int  n, i;

    if( narg == 0 )
	RETURN( "list what?\n" )
    n = MatchNames( args, narg, inputs.names, inputs.numInputs, sigList );
    if( n == 0 )
	RETURN( "no match\n" )
    PRINT( "INPUTS:  " );
    for( i = 0; i < n ; i++ )
      {
	PRINT( inputs.names[ sigList[ i ] ] );
	PUTC( ' ' );
      }
    PUTC( '\n' );
  }


void CmdLines( narg, args )	/* ARGSUSED */
  int   narg;
  char  *args[];
  {
    int  n;

    if( narg == 0 )
	RETURN( "How many lines?\n" )
    n = atoi( args[0] );
    if( n < 0 )
	RETURN( "You don't really want that!\n" )
    InitTextWindow( n );
    SetWindowParms();
    GetSignalPos();
    RedrawWindow( (Box*)NULL );
  }


void CmdHelp( narg, args )	/* ARGSUSED */
  int   narg;
  char  *args[];
  {
    LookupTable  *i;

    if( narg == 0 )
      {
	PRINT( "Commands are: " );
	for( i = CmdTable; i->cmd != NULL; i++ )
	    PRINT( i->cmd );
	PUTC( '\n' );
      }
    else
      {
	while( narg-- )
	  {
	    i = LookupCmd( *args, CmdTable );
	    if( i == NULL )
	      {
		PRINT( *args );
		PRINT( "=> Unknown command\n" );
	      }
	    else if( i->cmd != NULL )
	      {
		PRINT( i->cmd );
		PRINT( i->help );
		PUTC( '\n' );
	      }
	    args++;
	  }
      }
  }


void CmdMove( narg, args )	/* ARGSUSED */
  int   narg;
  char  *args[];
  {
    LookupTable  *dir;
    TimeType	 time;
    
    if( narg == 0 )
	RETURN( "move to where? (beginig, left, right, end, or time-step)\n" )
    if( isdigit( args[0][0] ) )
      {						/* move to time step */
	time = atoi( args[0] );
	if( time < times.first || time > times.last )
	    RETURN( "can't move there, time is out of bounds\n" )
	MoveTo( time );
      }
    else
      {
	dir = LookupCmd( args[0], Positions );
	if( dir == NULL )
	    RETURN( "Unknown direction for move\n" )
	switch( dir->opt )
	  {
	    case MovLeft :
		MoveTo( times.dispStart - times.dispSteps / 2 );
		break;
	    case MovRight :
		MoveTo( times.dispStart+times.dispSteps + times.dispSteps/2 );
		break;
	    case MovBeg :
		MoveTo( times.first );
		break;
	    case MovEnd :
		MoveTo( times.last );
		break;
	  }
      }
  }


void CmdMovetrace( narg, args )	/* ARGSUSED */
  int   narg;
  char  *args[];
  {
    int       tnum, pos;

    if( narg != 2 )
	RETURN( "Missiing arguments\n" );

    tnum = atoi( args[ 0 ] ) - 1;
    pos = atoi( args[ 1 ] ) - 1;
    if( (tnum < 0) || (tnum >= traces.numTraces) )
	RETURN( "No such trace number\n" );
    if( (pos < 0) || (pos >= traces.numTraces) )
	RETURN( "No such trace position\n" );
    MoveTracePos( tnum, pos );
  }



void CmdNext( narg, args )	/* ARGSUSED */
  int   narg;
  char  *args[];
  {
    TimeType  time;
    HistRef   hist;

    if( cursor.time < times.first )
	RETURN( "Cursor not set.\n" );
    hist = GetHist( cursor.time );
    if( hist != NULL )
	hist = hist->next;
    time = NextTrigger( hist );
    if( time < 0 )
	PRINT( "Trigger not found\n" );
    else
	MoveTo( time );
  }


void CmdPrevious( narg, args )	/* ARGSUSED */
  int   narg;
  char  *args[];
  {
    TimeType  time;
    HistRef   hist;

    if( cursor.time < times.first )
	RETURN( "Cursor not set.\n" );
    hist = GetHist( cursor.time );
    if( hist != NULL )
	hist = hist->prev;
    time = PrevTrigger( hist );
    if( time < 0 )
	PRINT( "Trigger not found\n" );
    else
	MoveTo( time );
  }



void CmdQuit( narg, args )	/* ARGSUSED */
  int   narg;
  char  *args[];
  {
    int  i;

    if (display != 0)
      XCloseDisplay(display) ;

    for( i = 0; i < 15; i++ )
	(void) close( i );
    exit(0);
  }


void CmdDelete( narg, args )	/* ARGSUSED */
  int   narg;
  char  *args[];
  {
    int      n, i;
    TrigEnt  *t, *t1;

    if( narg == 0 )
	RETURN( "Delete which trigger?\n" )
    n = atoi( args[0] );
    for( t = trigger.first, i = 1; t != NULL; i++, t = t->next )
	if( i == n )
	    break;
    if( t == NULL )
	RETURN( "No such trigger number\n" );
    
    if( t == trigger.first )
      {
	trigger.first = t->next;
	if( t == trigger.last )			/* remove the only trigger */
	    trigger.last = NULL; 
      }
    else
      {
	for( t1 = trigger.first; t1->next != t; t1 = t1->next );
	t1->next = t->next;
	if( t == trigger.last )
	    trigger.last = t1;
      }
    Mfree( t, sizeof( TrigEnt ) );
  }


void CmdRedraw( narg, args )	/* ARGSUSED */
  int   narg;
  char  *args[];
  {
    RedrawWindow( NULL );
  }


void CmdReclaim( narg, args )	/* ARGSUSED */
  int   narg;
  char  *args[];
  {
    int  n;

    if( narg == 0 )
      {
	n = ( times.last - times.first ) / 2;
	if( (n <= times.first) || (times.first == times.last) )
	    RETURN( "No need to reclaim memory\n" );
      }
    else
      {
	n = atoi( args[0] );
	if( n <= times.first )
	    RETURN( "You must be joking\n" );
      }
    RecoverMem( n, 1 );
  }


void CmdStatus( narg, args )	/* ARGSUSED */
  int   narg;
  char  *args[];
  {
    int      n, i;
    TrigEnt  *t;
    char     s[ 100 ];
    
    if( trigger.first == NULL )
      RETURN( "There are no triggers.\n" );
    if( narg > 0 )
      {
	n = atoi( args[0] );
	for( t = trigger.first, i = 1; t != NULL; i++, t = t->next )
	    if( i == n )
		break;
	if( t == NULL )
	    RETURN( "No such trigger\n" );
	sprintf( s, "Trigger <%d> is: ", i );
	PRINT( s );
	if( t->nsig == 1 )
	    PRINT( inputs.names[ t->index[0] ] );
	else
	  {
	    for( i = 0; i < t->nsig; i++ )
	      {
		PUTC( ' ' );
		PRINT( inputs.names[ t->index[ i ] ] );
	      }
	  }
	DisplayTrigger( t, s );
	PRINT( s );
	PUTC( '\n' );
	return;
      }

	/* display list of all triggers */

    PRINT( "Triggers are:  " );
    for( i = 1, t = trigger.first; t != NULL; i++, t = t->next )
      {
	if( i == 1 )
	    sprintf( s, "<%d> ", i );
	else
	    sprintf( s, ", <%d> ", i );
	PRINT( s );
	if( t->nsig == 1 )
	  strcpy( s, inputs.names[ t->index[0] ] );
	else
	  {
	    if( IsSameRoot( t->index, t->nsig ) )
	      {
		int   rlen, n1, n2;
		char  *r, *Root();
		
		r = Root( inputs.names[ t->index[0] ] );
		rlen = strlen( r );
		if( inputs.names[ t->index[0] ][ rlen ] == '[' )
		    rlen++;
		n1 = atoi( &(inputs.names[ t->index[0] ][ rlen ]) );
		n2 = atoi( &(inputs.names[ t->index[ t->nsig-1 ] ][ rlen ]) );
		sprintf( s, "%s[%d-%d]", r, n1, n2 );
	      }
	    else
	      {
		sprintf( s, "%s..%s", inputs.names[ t->index[0] ],
				 inputs.names[ t->index[ t->nsig-1 ] ] );
	      }
	  }
	PRINT( s );
	DisplayTrigger( t, s );
	PRINT( s );
      }
    PUTC( '\n' );
  }


void CmdStop( narg, args )	/* ARGSUSED */
  int   narg;
  char  *args[];
  {
    switch( windowState.simulStatus )
      {
	case RUNNING :
	    windowState.stop = 1;
	    break;
	case STOPPED :
	case STOP_NO_MEM :
	    PRINT( "Simulator is already stopped\n" );
	    break;
	case DEAD :
	    PRINT( "Can't stop simulator, it's dead\n" );
	    break;
      }
  }


void CmdTrace( narg, args )	/* ARGSUSED */
  int   narg;
  char  *args[];
  {
    int		 nsig, i;
    Uint	 trigVal;
    TriggerType	 tType, GetTriggerType();
    TrigEnt      *newT;
    
    if( narg < 3 )
	RETURN( "trigger what ?\n" )
    
    nsig = MatchNames( args, narg-2, inputs.names, inputs.numInputs, sigList);
    if( nsig == 0 )
	RETURN( "no signal match for trigger\n" )

    if( nsig > MAXBUSSIZE )
	RETURN( "sorry: maximum trigger size is 32 bits\n" )

    tType = GetTriggerType( args[ narg-2 ], args[ narg-1 ], &trigVal, nsig );
    if( tType == NO_TRIG )
	return;

    newT = (TrigEnt *) Malloc( sizeof( TrigEnt ) );
    if( newT == NULL )
	RETURN( "Can't allocate memory for trigger (abort)\n" )

    for( i = 0; i < nsig; i++ )
	newT->index[ i ] = sigList[ i ];

    newT->value = trigVal;
    newT->type = tType;
    newT->nsig = nsig;
    newT->next = NULL;
    if( trigger.first == NULL )
	trigger.first = newT;
    else
	trigger.last->next = newT;
    trigger.last = newT;
  }


void CmdWhatis( narg, args )	/* ARGSUSED */
  int   narg;
  char  *args[];
  {
    int       n;
    TraceEnt  *t;
    char      s[ 100 ];
    static  char *Map[] = { "2", "", "8", "16" };

    if( narg == 0 )
	RETURN( "Missing trace number\n" );
    n = atoi( args[ 0 ] ) - 1;
    if( (n < 0) || (n >= traces.numTraces) )
      {
	char  errMsg[ 50 ];
	
	sprintf( errMsg, "No such trace. Try [1-%d].\n", traces.numTraces );
	PRINT( errMsg );
	return;
      }
    sprintf( s, "Trace %d is: ", n+1 );
    PRINT( s );
    t = &( traces.traces[ n ] );
    for( n = 0; n < t->nsig; n++ )
      {
	PRINT( inputs.names[ t->signals[ n ] ] );
	PUTC( ' ' );
      }
    sprintf( s, " { base = %s }\n", Map[ t->bits-1 ] );
    PRINT( s );
  }



void CmdWidth( narg, args )	/* ARGSUSED */
  int   narg;
  char  *args[];
  {
    int  steps;

    if( narg == 0 )
	RETURN( "How many time-steps?\n" );

    if( times.first < 0 )
	return;
    steps = atoi( args[0] );
    if( steps > (times.last - times.first) )
	steps = times.last - times.first;
    if( steps <= 0 )
	steps = 2;
    if( steps % 2 != 0 )
	steps++;
    if( (times.dispStart + steps) > times.last )
	times.dispStart = times.last - steps;
    if( times.dispStart < times.first )
	times.dispStart = times.first;
    times.dispSteps = steps;
    RedrawTimes(); 
    RedrawTraces( times.dispStart, times.dispStart + times.dispSteps, 1 );
    UpdateScrollBar();
  }


void CmdZoom( narg, args )	/* ARGSUSED */
  int   narg;
  char  *args[];
  {
    LookupTable  *dir;
    
    if( narg == 0 )
	RETURN( "Zoom what?\n" );

    dir = LookupCmd( args[ 0 ], ZoomDir );
    if( dir == NULL )
	RETURN( "Unknown zoom direction.\n" );

    switch( dir->opt )
      {
	case ZoomIN :
	    times.dispSteps = times.dispSteps / 2;
	    if( times.dispSteps < 2 )
		times.dispSteps = 2;
	    break;
	case ZoomOUT :
	    times.dispSteps *= 2;
	    if( times.first < 0 )
		break;
	    if( times.dispSteps > (times.last - times.first) )
		times.dispSteps = times.last - times.first;
	    if( (times.dispStart + times.dispSteps) > times.last )
		times.dispStart = times.last - times.dispSteps;
	    if( times.dispStart < times.first )
		times.dispStart = times.first;
	    break;
	case SeeAll :
	    times.dispSteps = times.last - times.first;
	    if( times.dispSteps % 2 != 0 )
		times.dispSteps++;
	    times.dispStart = times.first;
	    break;
      }
    RedrawTimes();
    RedrawTraces( times.dispStart, times.dispStart + times.dispSteps, 1 );
    UpdateScrollBar();
  }


/*
 * Make sure display includes cursor
 */
void MoveTo( time )
  TimeType  time;
  {
    if( times.first < 0 )
	return;
    /* Check that time is within bounds */
    if( time > times.last )
	time = times.last;
    if( time < times.first )
	time = times.first;
    /* Check if we need to redraw */
    if( times.dispStart > time || (times.dispStart + times.dispSteps) < time )
      {
	times.dispStart = time - times.dispSteps / 2;
	if( (times.dispStart + times.dispSteps) > times.last )
	    times.dispStart = times.last - times.dispSteps;
	if( times.dispStart < times.first )
	    times.dispStart = times.first;
	RedrawTraces( times.dispStart, times.dispStart + times.dispSteps, 1 );
	RedrawTimes();
	UpdateScrollBar();
	MoveCursor( time );
      }
    else			/* No redraw, just move cursor */
      {
	MoveCursor( time );
      }
  }



/*
 * Set the value to compare the trigger and return the type of trigger.
 */
TriggerType GetTriggerType( eq, s, val, nbits )
  char  *eq;
  char  *s;
  Uint  *val;
  int   nbits;
  {
    int          err, i, eq_or;
    Uint	 maxVal;
    TriggerType  tType;
    
    err = 0;
    for( i = 0, maxVal = 0; i < nbits; i++ )
	maxVal = (maxVal << 1) | 1;

    if( *eq == '=' )
	eq_or = 1;
    else if( *eq == '|' )
	eq_or = 0;
    else
      {
	PRINT( "Syntax error, try only '=' or '|'\n" );
	return( NO_TRIG );
      }

    switch( *s )
      {
	case 'u' :
	case 'U' :
	    *val = UNDEF;
	    if( eq_or == 1 )
		tType = UorZ;
	    else
		tType = ANY_UorZ;
	    break;
	case 'z' :
	case 'Z' :
	    *val = FLOAT;
	    if( eq_or == 1 )
		tType = UorZ;
	    else
		tType = ANY_UorZ;
	    break;
	case 'x' :
	case 'X' :
	    if( eq_or == 1 )
		tType = CHANGE;
	    else
	      {
		PRINT( "Don't know what you mean, try '= X'\n" );
		return( NO_TRIG );
	      }
	    break;
	case '0' :
	case '1' :
	case '2' :
	case '3' :
	case '4' :
	case '5' :
	case '6' :
	case '7' :
	case '8' :
	case '9' :
	    *val = AsciiToInt( s, &err );
	    if( eq_or == 1 )
		tType = EQUAL;
	    else
		tType = ANY_EQ;
	    if( err )
	      {
		PRINT( "Syntax error in trigger value\n" );
		return( NO_TRIG );
	      }
	    if( *val > maxVal )
	      {
		PRINT( "Trigger value doesn't fit\n" );
		return( NO_TRIG );
	      }
	    break;
	default :
	    PRINT( "What? Trigger value may only be: NUMBER, Z, U, X\n" );
	    return( NO_TRIG );
      }

    if( (nbits == 1) && (tType != CHANGE) )
	return( ONE_BIT );
    else
	return( tType );
  }



/*
 * Convert trigger entry t into a displayable string.  Put result in s.
 */
void DisplayTrigger( t, s )
  TrigEnt  *t;
  char     *s;
  {
    static char  Map[] = "01UZ";
    char         ch;
    int          i;
    Uint         val;

    if( (t->type == ANY_EQ) || (t->type == ANY_UorZ) )
        ch = '|';
    else
	ch = '=';

    switch( t->type )
      {
	case EQUAL :
	case ANY_EQ :
	    *s++ = ' ';
	    *s++ = ch;
	    *s++ = ' ';
	    s += t->nsig;
	    *s-- = '\0';
	    for( i = 0, val = t->value; i < t->nsig; i++, s-- )
	      {
		*s = '0' + (val & 1);
		val = val >> 1;
	      }
	    break;
	case CHANGE :
	    sprintf( s, " %c change", ch );
	    break;
	case UorZ :
	case ANY_UorZ :
	case ONE_BIT :
	    sprintf( s, " %c %c", ch, Map[ t->value ] );
	    break;
	default :
	    sprintf( s, "INTERNAL ERROR: {Strange case %d}", (int)t->type );
      }
  }
