
/*
 *
 * Version identification:
 * @(#)event.c	1.2 11/23/92
 *
 */

#ifndef lint
static char rcsid[] = "$Header: event.c,v 1.6 87/05/11 16:51:56 rokicki Exp $";
#endif
/*
 * Logic analyzer event manager.
 */

#include <stdio.h>
#include <sys/types.h>
#ifndef FD_SET
/*
 *   Another crude hack made necessary buy problems with
 *   the SUN stuff.  These definitions are hacked up
 *   quickly, based on the distributed sun sys/types.h file,
 *   but I don't know how long they will work.
 */
#define	FD_SET(n, p)	((p)->fds_bits[0] |= (1 << (n)))
#define	FD_CLR(n, p)	((p)->fds_bits[0] &= ~(1 << (n)))
#define	FD_ISSET(n, p)	((p)->fds_bits[0] & (1 << (n)))
#define FD_ZERO(p)	bzero((char *)(p), sizeof(*(p)))
#endif
#include "defs.h"
#include "ipc.h"
#include "arrows.h"


#define max( a, b )		( ( (a) > (b) ) ? (a) : (b) )
#define NULLFDSET		( (fd_set *) NULL )
#define	WITHIN( y, box )	( (y >= box.bot) && (y <= box.top) )


#define MAXSTRING 128

void Exec();

void XEventHandler( simul_fd )
  int  simul_fd;
  {
    XEvent rep ;
    char         *simulData;
    char p[MAXSTRING] ;
    char *tp;
    XComposeStatus compose;
    KeySym keysym;
    int		 nfds, ready, server_fd, len;
    fd_set	 FDSet, fdSet;

    ready = 0 ;
    PUTC( '>' );
    server_fd = display->fd ;
    nfds = max( server_fd, simul_fd ) + 1;
    FD_ZERO( &FDSet );
    FD_SET( server_fd, &FDSet );
    if( simul_fd < 0 )
	windowState.simulStatus = DEAD;		/* no simulator */
    else
	FD_SET( simul_fd, &FDSet );
    fdSet = FDSet;

    for(;;)		/* forever until killed */
      {
	fdSet = FDSet;
        if (XPending(display) == 0)
           ready = select( nfds, &fdSet, NULLFDSET, NULLFDSET,
			  (struct timeval*)NULL );
        else
           FD_ZERO(&fdSet) ;
	if( ready == -1 )
	  {
	    ANALYZER_Crash( "ANALYZER: Select failed can't continue" );
	  }
	if( XPending(display) || FD_ISSET( server_fd, &fdSet ) )/* input from X */
        do {
           XNextEvent(display,&rep) ;
           switch( rep.type )
           {
case KeyPress:
   len = XLookupString(&rep, p, MAXSTRING, &keysym, &compose);
   tp = p;
   while (len > 0) {
      CharInput(*tp++) ;
      len-- ;
   }
   break ;
case ButtonPress:
   {
      XCoord x = rep.xbutton.x;
      YCoord y = YWINDOWSIZE - rep.xbutton.y;
      int time ;

      time = XToTime( x );
      if( WITHIN( y, scrollbar ) )
         DoScrollBar( x, y );
      else if( WITHIN( y, trace) ) {
         if( time != -1)
            MoveCursor( time );
         else if( (x < sigNames.right) && (x > 1 ) )
            MoveTrace( y );
      } else if (WITHIN(y, banner.box)) {
/*         if (xke->detail & (ControlMask | ShiftMask | MetaMask)) {
            XmyMakeWindow() ;
            XSelectInput(display,window, XDefaultSelects) ;
         } else
*/
            XRaiseWindow(display,window) ;
      }
   }
   break ;
case ButtonRelease:
   break ;
case EnterNotify:
   windowState.isSelected = 1;
   RedrawBanner();
   break ;
case LeaveNotify:
   windowState.isSelected = 0;
   RedrawBanner();
   break ;
case ConfigureNotify:

/* 2/1/90- Sam
 * Set this up so that a resize event is actually handled for X11R3
*/

   XWINDOWSIZE = rep.xconfigure.width ;
   YWINDOWSIZE = rep.xconfigure. height ;

   InitTextWindow( -1 );
   SetWindowParms();
   GetSignalPos();
   RedrawWindow( (Box*)NULL );
   break;
case Expose:

   /* get rid of other expose events */
   while (XCheckTypedEvent (display, Expose, &rep));
   InitTextWindow( -1 );
   SetWindowParms();
   GetSignalPos();
   RedrawWindow( (Box*)NULL );
   break ;
#if 0
/* don't handle regions */
case ExposeCopy:
   break ;
case ExposeRegion:
   redrawbox.left = xre->x ;
   redrawbox.right = xre->x + xre->width - 1 ;
   redrawbox.top = YWINDOWSIZE - xre->y ;
   redrawbox.bot = YWINDOWSIZE - (xre->y + xre->height - 1) ;
   RedrawWindow(&redrawbox) ; /* fix me */
   break ;
#endif
default: ;
}
      } while (XPending(display)) ;

	if( FD_ISSET( simul_fd, &fdSet ) )
	  {
	    switch( ipc_Receive( simul_fd, &simulData, &len ) )
	      {
		case SIGVALUES :
		  len = AddHist( ( CommHist *) simulData );
		  if( (len != 0) || (windowState.stop == 1) )
		    {
		      (void)ipc_Send( simul_fd, (char*)NULL, 0, STOP );
		      windowState.simulStatus = STOPPED;
		      windowState.stop = 0;
		      RedrawBanner();
		    }
		  else
		    {
		      (void)ipc_Send( simul_fd, (char*)NULL, 0, CONT );
		      windowState.simulStatus = RUNNING;
		    }
		  if( len < 0 )
		    {
		      PRINT( "To continue simulator try reclaim memory\n" );
		      windowState.simulStatus = STOP_NO_MEM;
		    }
		  break;
		case ADDSIGNAL :
		  AddNewSignal( (AddSigMsg *)simulData );
		  break;
		case DELETESIGNAL :
		  DeleteOldSignal( (DelSigMsg *)simulData );
		  break;
		case MOVESIGNAL :
		  RenameSignal( (RenSigMsg *)simulData );
		  break;
		case IPC_ERR :
		  FD_ZERO( &FDSet );		/* simulator finished */
		  FD_SET( server_fd, &FDSet );	/* don't try it again */
		  windowState.simulStatus = DEAD;
		  close( simul_fd );
		  RedrawBanner();
	      }
	  }
	if( windowState.restart )
	  {
	    if( ipc_Send( simul_fd, (char*)NULL, 0, CONT ) != IPC_OK )
	      {
		windowState.simulStatus = DEAD;
		close( simul_fd );
	      }
	    else
	      {
		windowState.simulStatus = RUNNING;
	      }
	    windowState.restart = 0;
	    RedrawBanner();
	  }

   }
}


#define RingBell	fprintf( stderr, "\007" )

#define	BACKSPACE	'\b'
#define DELETE		'\177'
#define	CTRL_W		'\027'
#define	CTRL_U		'\025'
#define	CTRL_R		'\022'
#define	RETURN		'\r'
#define	NEWLINE		'\n'
#define BUFFSIZE	256


CharInput( ch )
  char  ch;
  {
    static char  iBuff[ BUFFSIZE ];
    static char  *ibufPtr = iBuff;
    static char  *buffEnd = &( iBuff[ BUFFSIZE-1 ] );

    if( (ch == DELETE) || (ch == BACKSPACE) )
      {
	if( ibufPtr > iBuff )
	  {
	    PUTC( '\b' );
	    ibufPtr--;
	  }
      }
    else if( (ch == NEWLINE) || (ch == RETURN) )
      {
	PUTC( '\n' );
	*ibufPtr = '\0';
	Exec( iBuff );
	ibufPtr = iBuff;
	PUTC( '>' );
      }
    else if( ch == CTRL_W )
      {
	if( ibufPtr > iBuff )
	  {
	    ibufPtr--;
	    PUTC( BACKSPACE );
	    if( (*ibufPtr == ' ') && (ibufPtr > iBuff) )
	      {
		ibufPtr--;
		PUTC( BACKSPACE );
	      }
	    while( (*ibufPtr > ' ') && (ibufPtr > iBuff) )
	      {
		ibufPtr--;
		PUTC( BACKSPACE );
	      }
	    
	    if( *ibufPtr == ' ' )
	      {
		ibufPtr++;
		PUTC( ' ' );
	      }
	  }
      }
    else if( ch == CTRL_U )
      {
	while( ibufPtr > iBuff )
	  {
	    ibufPtr--;
	    PUTC( BACKSPACE );
	  }
      }
    else if( ch == CTRL_R )
      {
	PUTC( '\n' );
	*ibufPtr = '\0';
	PRINT( iBuff );
      }
    else
      {
	if( ibufPtr < buffEnd ) 
	  {
	    if( ch < ' ' )
		ch = ' ';
	    *ibufPtr++ = ch;
	    PUTC( ch );
	  }
	else
	  RingBell;
      }
  }
