
/*
 *
 * Version identification:
 * @(#)defs.h	1.1 8/26/91
 *
 */

#define defsRCSID "$Header: defs.h,v 1.2 87/05/05 13:32:20 rokicki Exp $"

/*
 * Definitions for all modules.  Note:  Do *not* define X or INTERVIEWS
 *    here; that should be done in the makefile.
 */



#include <X11/Xlib.h>
#include <X11/Xutil.h>


	/* defaults */
#define DEFBITS		4		/* groups of bits for buses */
#define MAXWINDOWSIZE	1000		/* largest window in coordinates */
#define TRACEGAP	4		/* trace separation in pixels */
#define MAXTRACES	100
#define MAXBUSSIZE	256
#define	DEFTEXTLINES	4		/* default text lines */
#define	SCROLLBARSIZE	12
#define DEFWINDOWHEIGHT	300		/* default size for window */
#define DEFWINDOWWIDTH	1000
#define GEOMETRY        "=1000x300"
#define DEFGEOMETRY     "=1000x300+0+0"
#define DEFBORDERWIDTH  3 

#define FOUT_EXT 	".ana"		/* output filename extension */
#define	PS_EXT		".ps"		/* PostScript filename extension */

#define round( x )	( (int) ( (x) + 0.5 ) )

#define TRUE 1
#define FALSE 0

#include "history.h"
#include "mem.h"

typedef unsigned int  Uint;

	/* signal definitions, same as in CSIM */
#define	ZERO	0
#define	ONE	1
#define	UNDEF	2
#define	FLOAT	3

typedef int XCoord ;
typedef int YCoord ;
#define BLACK 1
#define WHITE 0
#define PAINTFGBG 0
#define INVERT 1

typedef	int	Coord;

typedef struct			/* Bounding box */
  {
    XCoord  left;
    YCoord  bot;
    XCoord  right;
    YCoord  top;
  } Box;


typedef struct
  {
    int     nsig;			/* Number of signals in this group */
    int     bits;			/* Number of bits per digit */
    int     signals[ MAXBUSSIZE ];	/* Index of signal in trace */
    char    sameRoot;			/* 1 if bus has same prefix name */
    YCoord  bot;			/* y top position of trace */
    YCoord  top;			/* y base position of trace */
  } TraceEnt;


typedef struct
  {
    char  *model;		 	/* Name of the calle model */
    char  *source;			/* Source simulator */
  } Names;


typedef struct
  {
    int   numInputs;			/* number of input signals */
    char  *(names[ MAXINPUTS ]);	/* list of input signal names */
  } Inputs;


typedef struct
  {
    int       numTraces;		/* number of user-requested traces */
    int       dispTraces;		/* number of displayed traces */
    int       maxDigits;		/* maximum number of trace digits */
    int       maxName;			/* number of chars of longest name */
    TraceEnt  traces[ MAXTRACES ];	/* trace vector */
  } Traces;

/*
 *   Some pattern defines, for compatibility between X and InterViews.
 */
#define clearPat 0
#define solidPat 1
#define majorDiagPat 2
#define stipplePat 3

typedef enum		/* trigger when: */
  {
    EQUAL,		/* signal group == value */
    CHANGE,		/* bus/signal change */
    UorZ,		/* signal group == U | Z */
    ONE_BIT,		/* signal == value (0,1,U,Z) */
    ANY_EQ,		/* any bit in signal group == value */
    ANY_UorZ,		/* any bit in signal group == U | Z */
    NO_TRIG,		/* no trigger => error  in trigger specification */
  } TriggerType;


typedef struct TrigEnt
  {
    int             nsig;			/* num. of bits in trigger */
    TriggerType     type;			/* type of trigger entry */
    Uint            value;			/* trigger value */
    struct TrigEnt  *next;			/* next trigger in list */
    int             index[ MAXBUSSIZE ];	/* index of signal Levels */
  } TrigEnt;


typedef struct
  {
    TrigEnt  *first;		/* Head of Trigger list */
    TrigEnt  *last;		/* Tail of Trigger list */
    int      autostop;		/* flag => stop sim. on trigger */
  } Triggers;


typedef struct
  {
    TimeType  first;			/* first time recorded in history */
    TimeType  last;			/* last time recorded in history */
    TimeType  dispStart;		/* first simulation time on display */
    TimeType  dispSteps;		/* number of steps to display */
    Box       box;			/* Bounding box for times-display */
  } Times;


typedef struct
  {
    TimeType  time;		/* current cursor time */
    TimeType  exists;		/* if visible, old cursor time else -1 */
  } myCursor;


typedef struct
  {
    int  charHeight;
    int  charWidth;
    int  descent;
  } Metrics;


typedef enum { RUNNING, STOPPED, DEAD, STOP_NO_MEM } SimStat;

typedef struct
  {
    int  isSelected;		/* window selection */
    int  restart;		/* when set simulator will be restarted */
    int  stop;			/* when set simulator will be stopped */
    SimStat  simulStatus;	/* status of parent process (simulator) */
  } State;


typedef struct
  {
    Box   box;
    char  *left;
  } Banner;



typedef unsigned long Pixel;

			/* color information */
typedef struct
  {
    Pixel  black;
    Pixel  white;
    Pixel  traces;
    Pixel  hilite;
    Pixel  banner_bg;
    Pixel  banner_fg;
    Pixel  border;
    Pixel  disj;
    int    mono;
    int    color_hilite;
  } COL;

			/* pixmaps */
typedef struct
  {
    Pixmap  gray;		/* full plane pixmap */
    Pixmap  xpat;		/* full plane pixmap */
    Pixmap  left_arrows;	/* full plane pixmap */
    Pixmap  right_arrows;	/* full plane pixmap */
    Pixmap  tops[3];		/* full plane pixmap */
    Pixmap  bots[3];		/* full plane pixmap */
    Pixmap  chk;		/* full plane pixmap */
    Pixmap  icon;		/* bitmap */
    Pixmap  iconbox;
    Pixmap  sizebox;
    Pixmap  select;		/* select hilight pattern */
  } PIX;


			/* cursors */
typedef struct
  {
    Cursor  deflt;
    Cursor  left;
    Cursor  right;
    Cursor  timer;
    Cursor  move;
  } CURS;




	/* Global variables used by all modules */

extern int WindowSystem; /* 'X' for x, 'I' for interviews, 0 if not known */

extern char *display_name ;
extern Display *display ;
extern Window window ;
extern Screen  *screen;

extern XFontStruct *fontinfo ;
extern int xblack, xwhite ;
#define default_font "6x13"
#define XDefaultSelects  ExposureMask | StructureNotifyMask | \
	 KeyPressMask | ButtonPressMask | ButtonReleaseMask | \
         EnterWindowMask | LeaveWindowMask | ButtonMotionMask

extern PIX       pix;
extern COL       colors;
extern CURS      cursors;


extern int XWINDOWSIZE ;
extern int YWINDOWSIZE ;
extern Names      names;
extern Inputs     inputs;
extern Traces     traces;
extern Triggers   trigger;
extern Times      times;
extern myCursor   cursor;
extern Banner	  banner;
extern Metrics    metrics;
extern State      windowState;
extern Box	  text;
extern Box	  trace;
extern Box	  sigNames;
extern Box	  scrollbar;
extern Box	  cursVal;
	/* Exports from ANALYZER.c */
extern void	ANALYZER_Crash();

	/* Exports from convert.c */
extern Uint	AsciiToString();
extern char*	Convert();

	/* Exports from coords.c */
extern void	SetWindowParms();
extern void	GetSignalPos();
extern int	MaxTraceDigits();
extern int	MaxTraceName();

	/* Exports from event.c */
extern void	EventHandler();

	/* Exports from movetrace.c */
extern void	MoveTrace();
extern void	DeleteTrace();
extern void	MoveTracePos();

	/* Exports from names.c */
extern char*	AllocStr();
extern char*	GetName();
extern void	AddNewSignal();
extern void	RenameSignal();
extern void	DeleteOldSignal();
extern char*	Root();
extern int	IsSameRoot();

	/* Exports from scrollbar.c */
extern void	DrawScrollBar();
extern void	DoScrollBar();
extern void	UpdateScrollBar();

	/* Exports from trigger.c */
extern int	TriggerMatch();
extern TimeType	NextTrigger();
extern TimeType	PrevTrigger();

	/* Exports from txtwindow.c */
extern void	InitTextWindow();
extern void	PUTC();
extern void	PRINT();
extern void	ClearTextWindow();
extern void	RedrawText();

	/* Exports from window.c */
extern int	TimeToX();
extern TimeType	XToTime();
extern void	InitWindows();
extern void	RedrawWindow();
extern void	RedrawBanner();
extern void	RedrawTimes();
extern void	UpdateLastTime();
extern void	RedrawNames();
extern void	RedrawTraces();
extern void	ScrollTracesLeft();
extern HistRef	FindChanged();
extern void	MoveCursor();
extern void	EraseCursor();
extern void	DrawCursVal();
