
/*
 *
 * Version identification:
 * @(#)coords.c	1.1 8/26/91
 *
 */

#ifndef lint
static char rcsid[] = "$Header: coords.c,v 1.2 87/05/05 13:35:17 rokicki Exp $";
#endif

/*
 * Calculate the Position/bounding-boxes of all the objects on the screen.
 */

#include "defs.h"

#define CHARHEIGHT	(metrics.charHeight)
#define CHARWIDTH	(metrics.charWidth)
#define traceYsize	(trace.top - trace.bot)

#define max( a, b )	( ( (a) > (b) ) ? (a) : (b) )
int XWINDOWSIZE, YWINDOWSIZE ;
/*
 * Set the Bounding Box/Location of all the objects in the analyzer window.
 */
void SetWindowParms()
  {

    banner.box.right = XWINDOWSIZE - 1;
    banner.box.top = YWINDOWSIZE - 1;
    banner.box.left = 0;
    banner.box.bot = banner.box.top - CHARHEIGHT - 4;
    
    times.box.right = XWINDOWSIZE - 1;
    times.box.top = banner.box.bot - 1;
    times.box.left = 0;
    times.box.bot = times.box.top - CHARHEIGHT - 3;
    
    scrollbar.left = 1;
    scrollbar.bot = text.top;
    scrollbar.right = XWINDOWSIZE - 2;
    scrollbar.top = scrollbar.bot + SCROLLBARSIZE;
    
    sigNames.left = 1;
    sigNames.bot = scrollbar.top + 1;
    sigNames.right = CHARWIDTH * max( traces.maxName, 5 ) + 4;
    sigNames.top = times.box.bot - 1;
    
    cursVal.right = XWINDOWSIZE - 1;
    cursVal.top = times.box.bot - 1;
    cursVal.left = XWINDOWSIZE - 4 - (CHARWIDTH * max( traces.maxDigits, 5 ));
    cursVal.bot = scrollbar.top + 1;
    
    trace.left = sigNames.right + 1;
    trace.bot = scrollbar.top + 1;
    trace.right = cursVal.left - 1;
    trace.top = times.box.bot - 1;
    if( trace.right <= trace.left )	    /* in case window is too small */
      {
	trace.right = trace.left + 4;
      }
    if( (trace.right - trace.left) % 2 != 0 )	    /* make sure it's even */
      {
	trace.right--;
	cursVal.left--;
      }
    
    InitScrollBar();
  }


/*
 * Calculate vertical position of traces.
 */
void GetSignalPos()
  {
    TraceEnt  *t;
    int       i, pos, incr;
    int       busHeight, logicHeight, height;

    traces.dispTraces = traces.numTraces;
    height = TRACEGAP;
    busHeight = CHARHEIGHT + 4;		/* value + 2 spaces + 2 lines */
    logicHeight = CHARHEIGHT - 3;	/* a little smaller than a char */

    for( i = 0, t = traces.traces; i < traces.numTraces; i++, t++ )
      {
	height += ( ( t->nsig == 1 ) ? logicHeight : busHeight );
	height += TRACEGAP;
	if( height > traceYsize )
	  {
	    traces.dispTraces = i;
	    height -= ( ( t->nsig == 1 ) ? logicHeight : busHeight );
	    break;
	  }
      }

    if( traces.dispTraces > 0 )
	incr = max( (traceYsize - height) / traces.dispTraces, 0 );
    else
	incr = 0;

    busHeight += incr;
    logicHeight += incr;

    pos = trace.top - TRACEGAP;
    
    for( t = traces.traces, i = 0; i < traces.dispTraces; i++, t++ )
      {
        t->top = pos;
	pos -= ( ( t->nsig == 1 ) ? logicHeight : busHeight );
        t->bot = pos;
	pos -= TRACEGAP;
      }
  }



/*
 * Return the maximum number of digits required to display a trace value.
 */
int MaxTraceDigits()
  {
    int       i;
    int       ndigits, maxDigits;
    TraceEnt  *t;
    
    maxDigits = 0;
    for( t = traces.traces, i = 0; i < traces.numTraces; i++, t++ )
      {
	ndigits = ( t->nsig + t->bits - 1 ) / t->bits;
	if( ndigits > maxDigits )
	    maxDigits = ndigits;
      }
    return( maxDigits );
  }


/*
 * Return the length of the longest trace name.
 */
int  MaxTraceName()
  {
    int       i, maxLen, len, rlen;
    TraceEnt  *t;
    
    maxLen = 0;
    for( t = traces.traces, i = 0; i < traces.numTraces; i++, t++ )
      {
	if( t->nsig == 1 )
	    len = strlen( inputs.names[ t->signals[0] ] );
	else
	  {
	    if( t->sameRoot )
	      {
	        rlen = strlen( Root( inputs.names[ t->signals[0] ] ) );
		len = rlen + strlen( inputs.names[ t->signals[0] ] + rlen );
		len += strlen( inputs.names[ t->signals[t->nsig-1] ] + rlen );
		len += 3;		/* 3 for [ - ] */
	      }
	    else
	      {
		len = 10;	/* strlen( "GRP busnum [ nbits ]" ) */
	      }
	  }
	if( len > maxLen )
	    maxLen = len;
      }
    return( maxLen );
  }
