
/*
 *
 * Version identification:
 * @(#)ANALYZER.c	1.2 11/23/92
 *
 */

/*
 * Main analyzer (sub-process) program.
 */

#include <stdio.h>
#include <ctype.h>
#include <string.h>

#include "defs.h"
/*
 *   This routine determines which window system we are running
 *   under.
 */
int WindowSystem ;
char *display_name ;

void exit(), XEventHandler();
int atoi(), fprintf();

void which_window_system() {
   char *getenv() ;
/*
 *   If we are compiled under both environments, we try to determine
 *   which the user is currently running under from his environment
 *   variables.
 */

   WindowSystem = 'X' ;
   display_name = getenv("DISPLAY") ;
   if (display_name == NULL)
      ANALYZER_Crash("I can't find the display name") ;

}

int main( argc, argv )
  int   argc;
  char  *argv[];
  {
    int       commLink;
    register  i;
    
/*    i = 0;
    fprintf(stderr,"Analyzer started\n ");
    while(!i) {
     j = 1;
   } */
    which_window_system() ;
    if( argc != 5 )
        ANALYZER_Crash( "Wrong number of arguments" );

    names.model = AllocStr( strlen( argv[ 1 ] ) + 1 );
    names.source = AllocStr( strlen( argv[ 2 ] ) + 1 );
    banner.left = AllocStr( strlen( argv[2] ) + strlen( argv[1] ) + 15 );
    if( banner.left == NULL || names.source == NULL || names.source == NULL )
	ANALYZER_Crash( "sorry: Out of memory" );
    strcpy( names.model, argv[ 1 ] );
    strcpy( names.source, argv[ 2 ] );
    sprintf( banner.left, " %s analyzer (%s)", argv[2], argv[1] );
    inputs.numInputs = atoi( argv[ 3 ] );
    commLink = atoi( argv[ 4 ] );
    if( inputs.numInputs > MAXINPUTS ) {
        fprintf(stderr, "ANALYZER.c: Too many (%d) inputs (max %d)\n",
                inputs.numInputs, MAXINPUTS);
        ANALYZER_Crash( "Too many inputs\n" );
    }

    trigger.first = trigger.last = NULL;
    times.first = -1;
    times.last = -1;

    for( i = 0; i < inputs.numInputs; i++ )
      {
        inputs.names[ i ] = GetName( commLink );	/* Get signal name */
      }
    traces.numTraces = 0;
    traces.traces[ 0 ].nsig = 0;
    {
      char      newName[ 200 ] ,lastName[ 200 ], c;
      TraceEnt  *t;

      lastName[0] = '\0';
      for( i = 0, t = traces.traces; i < inputs.numInputs; i++)
	{
	  (void) strcpy( newName, Root( inputs.names[ i ] ) );
	  c = inputs.names[ i ][ strlen( newName ) ];
	  if( (i != 0) && (c == '[') && !strcmp( newName, lastName ) )
	    {
	      t->sameRoot = 1;
	      if( t->nsig == MAXBUSSIZE )
		{
		  t++;
		  traces.numTraces++;
		}
	      t->bits = DEFBITS;
	      t->signals[ t->nsig++ ] = i;
	    }
	  else
	    {
	      if( t->nsig > 0 )
		{
		  t++;
		  traces.numTraces++;
		}
	      t->nsig = 1;
	      t->bits= 1;
	      t->signals[ 0 ] = i;
	    }
	  (void) strcpy( lastName, newName );
	  if( traces.numTraces >= MAXTRACES - 1 )
	      break;
        }
    }

    if( traces.traces[ traces.numTraces ].nsig > 0 )
        traces.numTraces++;

    cursor.time = -1;		/* no cursor */
    cursor.exists = -1;
    times.dispStart = 0;
    times.dispSteps = 50;
    InitWindows();
    PRINT( argv[ 2 ] );  
    PRINT( " Logic Analyzer\n" );  
    XEventHandler( commLink ) ;
    return 0;
  }


void ANALYZER_Crash( msg )
  char  *msg;
  {
    if (display != 0)
      XCloseDisplay(display) ;
    fprintf(stderr, "%s\n",msg);
    exit( 1 );
  }

