defstar {
	name {Pad}
	domain {SDF}
	desc {
On each execution, reads a block of "nread" samples (default 128)
and writes a block of "nwrite" samples (default 256), where
"nwrite" >= "nread".  The samples may be of any type.

The first "offset" samples (default 0) have a zero value of the appropriate
type (messages of type DUMMY for message connections), the next "nread"
output samples have values taken from the inputs, and the remaining
"nwrite" - "nread" - "offset" samples have value 0 again.
	}
	version {@(#)SDFPad.pl	1.7	12/8/92}
	author { E. A. Lee, J. T. Buck }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { SDF main library }
	input {
		name{input}
		type{anytype}
	}
	output {
		name{output}
		type{=input}
	}
	defstate {
		name {nread}
		type {int}
		default {128}
		desc {Number of particles read.}
	}
	defstate {
		name {nwrite}
		type {int}
		default {256}
		desc {Number of particles written.}
	}
	defstate {
		name {offset}
		type {int}
		default {0}
		desc { Number of leading fill particles in each output block. }
	}
	setup {
		if (int(nwrite) < int(nread)) {
			Error::abortRun(*this,
			   ": nwrite cannot be less than nread");
			return;
		}
		input.setSDFParams(int(nread),int(nread)-1);
		output.setSDFParams(int(nwrite),int(nwrite)-1);
	}
	go {
		int inidx = int(nread) - 1;
		int hiLim = int(nwrite) - int(offset);
		int loLim = hiLim - int(nread);
		for (int i = int(nwrite) - 1; i >= 0; i--) {
			if (i >= hiLim || i < loLim)
				(output%i).initialize();
			else {
				output%i = input%inidx;
				inidx--;
			}
		}
	}
}
