defstar {
	name { MakeSeqATMCell }
	domain { SDF }
	author { GSWalter }
	version { @(#)SDFMakeSeqATMCell.pl	1.7 12/8/92 }
        copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
        }
	location { SDF conversion palette }
	desc {
Inputs 'numInfoBits' bits and loads them into a SeqATMCell object.
	}

	input { name { input } type { int } }
	output { name { output } type { message } }
	defstate {
		name { numInfoBits }
		type { int }
		default { 384 }
		desc { Number of information bits contained
		in a SeqATMCell message type. }
	}
	defstate {
		name { headerLength }
		type { int }
		default { 40 }
		desc { Number of bits in SeqATMCell to skip before loading in
		the information bits. }
	}

	hinclude { "SeqATMCell.h" }

	protected { int count; }

	setup {
		if ( numInfoBits > 384 )
			Error::abortRun( *this,
				"numInfoBits must be <= 384" );
		count = 0;
		input.setSDFParams( numInfoBits, numInfoBits - 1 );
	}

	go {
		LOG_NEW; SeqATMCell* voiceCell = new SeqATMCell( count );
		int index = headerLength;
		for ( int i = 0; i < numInfoBits; i++ ) {
			if ( int( input%( numInfoBits - 1 - i ) ) )
				voiceCell->set( index );
			index++;
		}
		Envelope envlp( *voiceCell );
		output%0 << envlp;
		count++;
		count %= 8;
	} // end go
} // end defstar
