#ifndef _DDFWormhole_h
#define _DDFWormhole_h 1
#ifdef __GNUG__
#pragma interface
#endif

#include "Wormhole.h"
#include "EventHorizon.h"
#include "DDFStar.h"
#include "DDFPortHole.h"

/*******************************************************************
 SCCS Version identification :
 @(#)DDFWormhole.h	2.12	3/16/93

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer : Soonhoi Ha
 Date of Creation : 8/13/90
	
********************************************************************/

	//////////////////////////////
	// DDFWormhole
	//////////////////////////////

class DDFWormhole : public Wormhole, public DDFStar {

public:

	void setup() {initWait(); Wormhole :: setup() ;}
	void go();
	void wrapup() { target->wrapup();}
	// constructor
	DDFWormhole(Galaxy &g,Target* t = 0) : Wormhole(*this,g,t), stick(0) {
		buildEventHorizons ();
	}

	// destructor
	~DDFWormhole() { if (!stick) freeContents(); }

	Scheduler* scheduler() const { return target->scheduler();}

	// print method
	StringList print(int verbose) const { return Wormhole::print(verbose);}

	// clone -- allows interpreter to make copies
	Block* clone() const;
	Block* makeNew() const;

	// identify myself as a wormhole
	int isItWormhole() const { return TRUE;}

        // return myself
        DDFWormhole* myWorm();

	// use statelist for inner galaxy for stateWithName
	State* stateWithName (const char* name) {
		return gal.stateWithName(name);
	}

	// state initialize
	void initState() { gal.initState() ;}

	// change galaxy. -- for memory management purpose. look at "deCrust()"
	// method in DDFAutoWorm.cc file.
	void stickGal() { stick = TRUE; }

protected:
	// redefine the getStopTime() method.
	double getStopTime();

	// no need for sumUp() method.

private:
	int stick;	// flag for the destructor.
};

	
        //////////////////////////////////////////
        // class DDFtoUniversal
        //////////////////////////////////////////


// Input Boundary of ??inDDF_Wormholes.
class DDFtoUniversal : public ToEventHorizon, public InDDFPort
{
public:
	// constructor
	DDFtoUniversal() : ToEventHorizon(this) {}

	// redefine
	void receiveData(); 

	void initialize();

	int isItInput() const;
	int isItOutput() const;

	// as Eventhorizon
	EventHorizon* asEH();
};

        //////////////////////////////////////////
        // class DDFfromUniversal
        //////////////////////////////////////////

// Output Boundary of ??inDDF_Wormholes.
class DDFfromUniversal : public FromEventHorizon, public OutDDFPort
{
public:
	// constructor
	DDFfromUniversal() : FromEventHorizon(this) {}

	void sendData();

	void initialize();

	int isItInput() const;
	int isItOutput() const;

	// as Eventhorizon
	EventHorizon* asEH();
};
	
#endif
