static const char file_id[] = "DDFWormhole.cc";
/******************************************************************
Version identification:
 @(#)DDFWormhole.cc	2.11	3/16/93

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer: Soonhoi Ha 
 Date of creation: 8/23/90

*******************************************************************/
#ifdef __GNUG__
#pragma implementation
#endif

#include "DDFWormhole.h"
#include "DDFScheduler.h"

/*******************************************************************

	class DDFWormhole methods

********************************************************************/

void DDFWormhole :: go()
{
	BlockPortIter nextp(*this);
	for (int i = numberPorts(); i > 0; i--) {
		PortHole& port = *nextp++;
		port.receiveData();
	}

	// synchronize two domains
	target->setCurrentTime(outerSched()->now());

	// run the inner scheduler
	Wormhole::run();

	nextp.reset();
	for (i = numberPorts(); i > 0; i--) {
		PortHole& port = *nextp++;
		port.sendData();
	}
}

// get next token's arrival time
double DDFWormhole :: getStopTime() {
	DDFScheduler* sched = (DDFScheduler*) outerSched();
	return (sched->now() + sched->schedulePeriod) ;
}

DDFWormhole* DDFWormhole :: myWorm() {
        return this;
}

// cloner -- clone the inside and make a new wormhole from that.
Block* DDFWormhole :: clone() const
{
LOG_NEW; return new DDFWormhole(gal.clone()->asGalaxy(), target->cloneTarget());
}

// makeNew, analogous to clone.
Block* DDFWormhole :: makeNew() const
{
LOG_NEW; return new DDFWormhole(gal.makeNew()->asGalaxy(),
				target->cloneTarget());
}

/**************************************************************************

	methods for DDFtoUniversal

**************************************************************************/

void DDFtoUniversal :: receiveData()
{
	// 1. get data.
	getData();

	// check if it is an input or output.
	if (DDFtoUniversal :: isItInput()) {	
		// 2. pass currentTime from outside to inside.
		timeMark = outerSched()->now();
	} else {
		// 2. annul increment of currentTime at the end of run.
		DDFScheduler* sched = (DDFScheduler*) innerSched();
		timeMark = sched->now() - sched->schedulePeriod;
	} 

	// 3. transfer data
	transferData();
}

void DDFtoUniversal :: initialize() {
	PortHole :: initialize();
	ToEventHorizon :: initialize();         
}

int DDFtoUniversal :: isItInput() const 
	{ return EventHorizon :: isItInput(); }
int DDFtoUniversal :: isItOutput() const 
	{ return EventHorizon :: isItOutput(); }

EventHorizon* DDFtoUniversal :: asEH() { return this; }

/**************************************************************************

	methods for DDFfromUniversal

**************************************************************************/

void DDFfromUniversal :: sendData ()
{
// It sends a data to the Geodesic from the Universal EventHorizon

	// 1. transfer the data
	transferData();

   while (tokenNew) {
	// no timeMark business since DDF is an "untimed" domain.

	// 2. put the data
	putData();
	transferData();
   }
}

void DDFfromUniversal :: initialize() {
	PortHole :: initialize();
	FromEventHorizon :: initialize();  
}

int DDFfromUniversal :: isItInput() const 
	{ return EventHorizon :: isItInput(); }
int DDFfromUniversal :: isItOutput() const 
	{ return EventHorizon :: isItOutput(); }

EventHorizon* DDFfromUniversal :: asEH() { return this; }

