static const char file_id[] = "Recur.cc";
#ifdef __GNUG__
#pragma implementation
#endif

#include "type.h"
#include "Recur.h"
#include "DDFStar.h"
#include "GalIter.h"
#include "State.h"

/**************************************************************************
Version identification:
@(#)Recur.cc	1.7	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  Soonhoi Ha
 Date of creation: 7/8/91

 methods for "Recur" construct.

**************************************************************************/

extern void renewNumTokens(Block* b, int flag);

Star* lastWorm;
Star* firstWorm;

	////////////////////////////
	// clearSchedules
	////////////////////////////

void Recur :: clearSchedules() {

	selfArm = 0;
	for (int i = 0; i < 4; i++)
		schedules[i].initialize();
}

	////////////////////////////
	// checkTopology
	////////////////////////////

int numSelf;

int Recur :: checkTopology (Galaxy& galaxy) {

	GalStarIter nextStar(galaxy);
	Star* s;

	// check the topology
	// 1. check whether other stars are DDFWormholes of SDF domain, 
	//    Self Stars, Select Stars, or Switch Stars.
	// 2. check the connections.
	
	nextStar.reset();
	numSelf = 0;
	while ((s = nextStar++) != 0) {

		if (s->isItWormhole()) {
			if (checkWorms(s) == FALSE)
				return FALSE;
		} else {
			if (checkStars(s, galaxy) == FALSE)
				return FALSE;
		}
	}
	if (!numSelf) return FALSE;

	schedules[2].append(lastWorm);
	schedules[0].prepend(firstWorm);

	return TRUE;
}

int Recur :: checkStars(Star* s, Galaxy& galaxy) {

	DDFStar* ds = (DDFStar*) s;
	const char* nm = ds->readTypeName();

	// check the connection of the EndCase Star
	if (!strcmp(nm, "EndCase")) {
	   	PortHole* p;
	   	BlockPortIter nextp(*s);
	
		while ((p = nextp++) != 0) {
			if (p->isItInput()) {
			    const char* tc = p->name();
			    if (!strcmp(tc, "control")) {
			   	DDFStar* ts = (DDFStar*) p->far()->parent();
			   	if (!ts->isItWormhole() && 
					strcmp(ts->readTypeName(), "Fork"))
			      		return FALSE;
			    } 
			} else if (p->far()->isItInput())
				return FALSE;
		} // end of while
		schedules[3].put(s);

	// check the connection of the Case Star
	} else if (!strcmp(nm, "Case")) {
		PortHole* p;
		BlockPortIter nextp(*s);
	
		while ((p = nextp++) != 0) {
			const char* tc = p->name();
			if (!strcmp(tc, "control")) {
			   DDFStar* ts = (DDFStar*) p->far()->parent();
			   if (!ts->isItWormhole() && 
				strcmp(ts->readTypeName(), "Fork"))
			      return FALSE;
			}
		}
		schedules[0].put(s);

        } else if (!strcmp(nm, "Fork")) {
                PortHole* p;
                BlockPortIter nextp(*s);
                while ((p = nextp++) != 0) {
                        if (p->isItOutput()) {
                               if(strcmp(p->far()->name(), "control"))
                                        return FALSE;
			} else {
				if (!p->far()->parent()->isItWormhole())
					return FALSE;
			}
                }
                schedules[0].prepend(s);

	} else if (strcmp(nm, "Self")) {
	    	return FALSE;
	} else {
		numSelf++;
		State* st = s->stateWithName("recurGal");
		if (st && strcmp(st->initValue(), galaxy.name()))
			return FALSE;

	   	PortHole* p;
	   	BlockPortIter nextp(*s);
		int errorFlag = 0;
	
		while ((p = nextp++) != 0) {
			DDFStar* ds = (DDFStar*) p->far()->parent();
			if (!ds->isItWormhole()) {
				if (p->isItInput()) {
				    if (strcmp(ds->name(), "Case"))
					return FALSE;
				} else {
				    if (strcmp(ds->name(), "EndCase"))
					return FALSE;
				}
				const char* nm = p->far()->name();
				int temp = 0;
				if (strcmp(nm, "control"))
					temp = nm[7] - '0';
				else return FALSE;
				if (selfArm && selfArm != temp)
					errorFlag = 1;
			}
		}
		if (errorFlag) {
			Error::abortRun(*s,
"should lie in either true or false arms.");
			return FALSE;
		}
		schedules[2].put(s);
	}

	return TRUE;
}


int Recur :: checkWorms(Star* s) {

	// check connections of the Wormholes.
	PortHole* p;
	BlockPortIter nextp(*s);
	int inNum = 0;
	int type = 0;
	int errorFlag = 0;
	int selfFlag = 0;
	
	while ((p = nextp++) != 0) {

		// check numberTokens
		if (p->numberTokens > 1) return FALSE;

	    	if (p->isItInput()) {
	   		if (p->far()->isItOutput()) {
				inNum++;
				DDFStar* z = (DDFStar*) p->far()->parent();
	 			const char* zc = z->readTypeName();
				if (!strcmp(zc, "Case")) {
					const char* nm = p->far()->name();
					if (nm[7] == '2') {
						if (type == 1) errorFlag = 1;
						else type = 2;
					} else {
						if (type == 2) errorFlag = 1;
						else type = 1;
					}
				} else if (!strcmp(zc, "Self"))
					selfFlag = 2;
				else	return FALSE;
			}

	    	} else if (p->far()->isItInput()) {

			DDFStar* z = (DDFStar*) p->far()->parent();
	 		const char* zc = z->readTypeName();
			if (!strcmp(zc, "EndCase")) {
				const char* nm = p->far()->name();
				if (nm[6] == '2') {
					if (type == 1) errorFlag = 1;	
					else type = 2;
				} else if (nm[6] == '1') {
					if (type == 2) errorFlag = 1;
					else type = 1;
				} 
			} else if (!strcmp(zc, "Self"))
				selfFlag = 1;
			else if (!strcmp(zc, "Case")) {
				const char* nm = p->far()->name();
				if (!strcmp(nm, "control")) {
					// initialize testPort.
					testPort = (DDFPortHole*) p->far();
				}
			} else if (strcmp(zc, "Fork"))
				return FALSE;
	    	}
	}
		
	// check selfFlag to set the selfArm
	if (selfFlag) {
		if ((selfArm > 0) && (selfArm != type))
			errorFlag = 1;
		else
			selfArm = type;
	}

	// looking at the error flag first.
	if (errorFlag) {
		Error::abortRun(*s, "should lie in either true or false arm.");
		return FALSE;
	}
	
	// next, number of input portholes.
	if (inNum == 0 && type == 0)  {
		firstWorm = s;   	// put at the head.
	  	return TRUE;
	}

	// next, type is undefined.
	if (!type)	return FALSE;

	// next, decide recurArm..
	if (selfFlag == 1) 	schedules[2].prepend(s);
	else if (selfFlag == 2)	lastWorm = s;
	else  		schedules[1].append(s);
					
	return TRUE;
}
