static const char file_id[] = "ForScheduler.cc";
#ifdef __GNUG__
#pragma implementation
#endif

#include "type.h"
#include "ForScheduler.h"
#include "Star.h"

/**************************************************************************
Version identification:
@(#)ForScheduler.cc	1.7	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  Soonhoi Ha
 Date of creation: 1/3/91
 Date of Revision: 7/8/91

 For Scheduler methods

**************************************************************************/

/************************************************************************

	For Scheduler

*************************************************************************/


	////////////////////////////
	// run
	////////////////////////////

int ForScheduler :: run () {

	ListIter up(schedules[0]);
	ListIter body(schedules[1]);
	ListIter down(schedules[2]);

	Star* s;

	while ((s = (Star*) up++) != 0)
		s->run();

	// fetch the main wormhole.
	// if there is no UpSample actor...
	if (noUp) {
		int numFiring = (*testPort)%0;
		while ((s = (Star*) body++) != 0) {
			for (int i = numFiring; i > 0; i--)
				s->run();
		}
	} else { // if there is UpSample actor
	   while ((s = (Star*) body++) != 0) {
		int flag = 0;
		do {
			PortHole* p;
			BlockPortIter nextp(*s);
			flag = 0;

			// check whether it is runnable or not.
			while ((p = nextp++) != 0) {
				if (p->isItInput() &&
					p->numTokens() < p->numberTokens)
					flag++;
			}

			if (!flag)  s->run() ;
		} while (!flag);
	   }
	}

	// fire DownSample classes
	while ((s = (Star*) down++) != 0)
		s->run();

	return !haltRequested();
}
	
int ForScheduler :: checkType(Galaxy& galaxy) {
	For::clearSchedules();
	return For::checkTopology(galaxy);
}

DyConScheduler* ForScheduler :: copy() { LOG_NEW; return new ForScheduler; }
