static const char file_id[] = "DoWhile.cc";
#ifdef __GNUG__
#pragma implementation
#endif

#include "type.h"
#include "DoWhile.h"
#include "GalIter.h"
#include "DDFStar.h"

/**************************************************************************
Version identification:
@(#)DoWhile.cc	1.6	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  Soonhoi Ha
 Date of creation: 7/8/91

 Methods for "DoWhile" construct.

**************************************************************************/

extern void renewNumTokens(Block* b, int flag);

	////////////////////////////
	// clearSchedules
	////////////////////////////

void DoWhile :: clearSchedules () {
	schedules[0].initialize();	// EndCase stars and wormhole
	schedules[1].initialize();	// Case Stars.
	testPort = (DDFPortHole*) 0;
}

	////////////////////////////
	// checkTopology
	////////////////////////////

int DoWhile :: checkTopology (Galaxy& galaxy) {

	GalStarIter nextStar(galaxy);
	Star* s;

	// check the topology
	// 1. check whether stars are an Wormhole,
	//    Select Stars, or Switch Stars.
	// 2. check the Wormhole is connected to Select, Switch,
	//    or Fork stars.
	// 3. check the control arc and the feedback arcs.
	
	nextStar.reset();
	int wormCount = 0;
	while ((s = nextStar++) != 0) {

		if (s->isItWormhole()) {

			wormCount++;
			if (wormCount > 1) return FALSE;

			// check connections of the Wormholes.
			PortHole* p;
			BlockPortIter nextp(*s);
	
			while ((p = nextp++) != 0) {

			   // check numberTokens
			   if (p->numberTokens > 1) return FALSE;

			   DDFStar* ds = (DDFStar*) p->far()->parent();
			   const char* nm = ds->readTypeName();
			   if (p->isItInput()) {
				if(strcmp(nm,"EndCase")) {
				   return FALSE;
				}
			   } else {
			      if (strcmp(nm,"Case") && strcmp(nm, "Fork") &&
				  strcmp(p->far()->name(), "control")) {
				   return FALSE;
			      }
			   }
			}
			schedules[0].put(s);

		} else {
			DDFStar* ds = (DDFStar*) s;

			// check the connection of the Select Star
			if (!strcmp(ds->readTypeName(), "EndCase")) {

			   PortHole* p;
			   BlockPortIter nextp(*s);
	
			   while ((p = nextp++) != 0) {
				if (p->isItInput() && p->far()->isItOutput()) {
				    const char* tc = p->name();
				    if (!strcmp(tc, "control")) {
					DDFStar* ts = 
						(DDFStar*) p->far()->parent();
					if (!ts->isItWormhole() && strcmp (
					   ts->readTypeName(), "Fork"))
						return FALSE;
					if ((p->numTokens()) != 1)
						return FALSE;
				   } else if (strcmp(tc, "input#2")) {
						return FALSE;
				   } else {
					tc = p->far()->name();
					if (strcmp(tc, "output#2"))
						return FALSE;
				   }
				} 
			   } // end of while
			   schedules[0].prepend(s);
			}

			// check the connection of the Switch Star
			else if (!strcmp(ds->readTypeName(), "Case")) {
			   PortHole* p;
			   BlockPortIter nextp(*s);
	
			   while ((p = nextp++) != 0) {
				const char* tc = p->name();
				if (!strcmp(tc, "control")) {
				   testPort = (DDFPortHole*) p;
				   DDFStar* ts = (DDFStar*) p->far()->parent();
				   if (!ts->isItWormhole() && strcmp (
					   ts->readTypeName(), "Fork"))
						return FALSE;
				} else if (!strcmp(tc, "output#1")) {
					if (p->far()->isItInput())
						return FALSE;
				}
			   }
			   schedules[1].put(s);
                        } else if (!strcmp(ds->readTypeName(), "Fork")) {
                                PortHole* p;
                                BlockPortIter nextp(*s);
                                while ((p = nextp++) != 0) {
                                        if (p->isItOutput()) {
                                           if(strcmp(p->far()->name(),
                                                "control"))
                                                return FALSE;
					} else {
					   Block* ts = p->far()->parent();
					   if (!ts->isItWormhole())
						return FALSE;
				 	}
                                }
                                schedules[1].prepend(s);
			} else {
				return FALSE;
			}
		}
	}

	renewNumTokens(galaxy.parent(), FALSE);
	return TRUE;
}

