static const char file_id[] = "Case.cc";
/**************************************************************************
Version identification:
@(#)Case.cc	1.8	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  Soonhoi Ha
 Date of creation: 7/8/91

 Methods for "Case" construct.

**************************************************************************/

#ifdef __GNUG__
#pragma implementation
#endif

#include "type.h"
#include "Case.h"
#include "GalIter.h"
#include "DDFStar.h"

extern void renewNumTokens(Block* b, int flag);

	////////////////////////////
	// checkNumArcs
	////////////////////////////

void Case :: checkNumArcs(Galaxy& galaxy) {

	numArc = 0;

	// check the number of branches
	GalStarIter nextStar(galaxy);
	Star* s;
	
	while ((s = nextStar++) != 0) {
		DDFStar* ds = (DDFStar*) s;
		const char* nm = ds->readTypeName();
		if (!strcmp(nm, "Case") || !strcmp(nm, "EndCase")) {
			numArc = ds->numberPorts();
			break;
		}
	}
}

	////////////////////////////
	// clearSchedules
	////////////////////////////

void Case :: clearSchedules () {

	testPort = 0;

	// initialize star list
	if (schedules) { LOG_DEL; delete schedules;
			 schedules = NULL; }
	if (numArc) {
		LOG_NEW; schedules = new SequentialList[numArc];
	}
	for (int i = 0; i < numArc; i++)
		schedules[i].initialize();
}

	////////////////////////////
	// checkTopology
	////////////////////////////

int Case :: checkTopology (Galaxy& galaxy) {

	// check the number of branches
	GalStarIter nextStar(galaxy);
	Star* s;
	
	// check the topology
	// 1. check whether stars are all Wormholes,
	//    Case Stars, or EndCase Stars.
	// 2. check the Wormholes are connected to  a Case and an EndCase
	//    stars.
	
	nextStar.reset();
	while ((s = nextStar++) != 0) {

		if (s->isItWormhole()) {

			// check connections.
			PortHole* p;
			BlockPortIter nextp(*s);
			int flag = 0;
			int index = 0;
			int errorFlag = 0;
	
			while ((p = nextp++) != 0) {

			   if (p->atBoundary()) {
				flag++;
				continue;
			   }

			   // check numberTokens
			   if (p->numberTokens > 1) return FALSE;

			   DDFStar* ds = (DDFStar*) p->far()->parent();
			   if (p->isItInput()) {
				if (strcmp(ds->readTypeName(), "Case")) { 
				   return FALSE;
				} 
				const char* nm = p->far()->name();
				int temp = nm[7] - '0';
				if (index == 0) index = temp;
				else if (index != temp) {
					errorFlag = 1;
				}
			   } else {
			      if (!strcmp(ds->readTypeName(),"EndCase")) {
				  const char* nm = p->far()->name();
				  if (strcmp(nm, "control")) {
					int temp = nm[6] - '0';
					if (index == 0) index = temp;
					else if (index != temp) 
						errorFlag = 1;
				  }
			      } 
			      else if (strcmp(p->far()->name(),"control"))
					return FALSE;
			      else if (strcmp(ds->readTypeName(), "Case"))
					return FALSE;
			   }
			}
			if (errorFlag) {
				Error::abortRun(*s,
"may not lie on more than one branch.");
				return FALSE;
			}

			if (flag > 1)		return FALSE;
			else if (flag == 1)  	schedules[0].prepend(s);
			else if (index)	    	schedules[index].append(s);
			else			return FALSE;

		} else {
			DDFStar* ds = (DDFStar*) s;
			const char* nm = ds->readTypeName();
			if (!strcmp(nm, "Case")) {
				PortHole* p;
				BlockPortIter nextp(*s);
	
				while ((p = nextp++) != 0) {
				   if (!strcmp(p->name(), "input")) {
					if (p->far()->isItOutput())
						return FALSE;
				   } else if (!strcmp(p->name(),"control"))
					testPort = p;
				}
				schedules[0].put(s);
			} else if (!strcmp(nm, "EndCase")) {
				PortHole* p;
				BlockPortIter nextp(*s);
	
				while ((p = nextp++) != 0) {
				   if (p->isItOutput()) {
					if (p->far()->isItInput()) {
						return FALSE;
					}
				   } else if (!strcmp(p->name(),"control"))
					if(!testPort) testPort = p->far();
				}
				int index = numArc - 1;
				schedules[index].put(s);
                        } else if (!strcmp(nm, "Fork")) {
                                PortHole* p;
                                BlockPortIter nextp(*s);
                                while ((p = nextp++) != 0) {
                                        if (p->isItOutput())
                                           if(strcmp(p->far()->name(),
                                                "control"))
                                                return FALSE;
                                }
                                schedules[0].prepend(s);
			} else {
				return FALSE;
			}
		}
	}

	renewNumTokens(galaxy.parent(), FALSE);
	return TRUE;
}

