static const char file_id[] = "../../../../src/domains/cgc/stars/CGCXMgraph.pl";
// .cc file generated from ../../../../src/domains/cgc/stars/CGCXMgraph.pl by ptlang
/*
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
 */

#ifdef __GNUG__
#pragma implementation
#endif

#include "KnownBlock.h"
#include "CGCXMgraph.h"
#include "Target.h"

const char *star_nm_CGCXMgraph = "CGCXMgraph";

const char* CGCXMgraph :: className() const {return star_nm_CGCXMgraph;}

Block* CGCXMgraph :: makeNew() const { LOG_NEW; return new CGCXMgraph;}

CodeBlock CGCXMgraph :: err (
"    {\n"
"        fprintf(stderr,\"ERROR: cannot open output file for Xgraph star.\\n\");\n"
"	exit(1);\n"
"    }\n"
);

CodeBlock CGCXMgraph :: closeFile (
"    for (i = 0; i < $val(numIn); i++) fclose($starSymbol(fp)[i]);\n"
);

CGCXMgraph::CGCXMgraph ()
{
	setDescriptor("Generate a multi-signal plot with the xgraph program.");
	addPort(input.setPort("input",this,FLOAT));
	addState(title.setState("title",this,"X graph","Title for the plot."));
	addState(saveFile.setState("saveFile",this,"","File name for saving plottable data."));
	addState(options.setState("options",this,"","Command line options for the xgraph program."));
	addState(ignore.setState("ignore",this,"0","Number of initial values to ignore."));
	addState(xUnits.setState("xUnits",this,"1.0","For labeling, horizontal increment between samples."));
	addState(xInit.setState("xInit",this,"0.0","For labeling, horizontal value of the first sample."));
	addState(numIn.setState("numIn",this,"1","numIn",
# line 69 "../../../../src/domains/cgc/stars/CGCXMgraph.pl"
A_NONCONSTANT|A_NONSETTABLE));
	addState(index.setState("index",this,"0.0","index",
# line 75 "../../../../src/domains/cgc/stars/CGCXMgraph.pl"
A_NONCONSTANT|A_NONSETTABLE));
	addState(ix.setState("ix",this,"0","ix",
# line 81 "../../../../src/domains/cgc/stars/CGCXMgraph.pl"
A_NONCONSTANT|A_NONSETTABLE));
	addState(iy.setState("iy",this,"0","iy",
# line 87 "../../../../src/domains/cgc/stars/CGCXMgraph.pl"
A_NONCONSTANT|A_NONSETTABLE));


}

void CGCXMgraph::wrapup() {
# line 140 "../../../../src/domains/cgc/stars/CGCXMgraph.pl"
addCode("    { int i;\n");

		// close the files
		addCode(closeFile);

		StringList cmd;
		cmd << "( ";

		// save File
		const char* sf = saveFile;
		if (sf != NULL && *sf != 0) {
			for (int i = 0; i<int(numIn); i++) {
				cmd << "; /bin/cat ";
				cmd << targetPtr->name(); 
				cmd << "_$starSymbol(temp)" << i << " >> ";
				cmd << sf << "; /bin/echo \"\" >> " << sf;
				cmd << "; ";
			}
		}

		cmd << "xgraph ";

		// put title on command line

		const char* ttl = title;

		if (ttl && *ttl) {
			if (strchr(ttl,'\'')) {
				cmd << "-t \"" << ttl << "\" ";
			}
			else {
				cmd << "-t '" << ttl << "' ";
			}
		}

		const char* opt = options;

		// put options on the command line
		if (opt && *opt) {
			cmd << opt << " ";
		}

		// put file names
		for (int i = 0; i < int(numIn); i++) {
			cmd << targetPtr->name() << "_$starSymbol(temp)";
			cmd << i << " ";
		}

		// remove temporary files
		for (i = 0; i < int(numIn); i++) {
			cmd << "; /bin/rm -f " << targetPtr->name();
			cmd << "_$starSymbol(temp)" << i;
		}

		cmd << ") &";
		StringList out = "    system(\"";
		out << cmd << "\");\n    }\n";
		addCode(out);
}

void CGCXMgraph::initCode() {
# line 100 "../../../../src/domains/cgc/stars/CGCXMgraph.pl"
StringList s;
		s << "    FILE* $starSymbol(fp)[";
		s << input.numberPorts() << "];";
                addDeclaration(s);
                addInclude("<stdio.h>");
		for (int i = 0; i < input.numberPorts(); i++) {
			StringList w = "    if(!($starSymbol(fp)[";
			w << i <<  "] = fopen(\"";
			w << targetPtr->name() << "_$starSymbol(temp)";
			w << i << "\",\"w\")))";
			addCode(w);
			addCode(err);
		}
}

void CGCXMgraph::setup() {
# line 94 "../../../../src/domains/cgc/stars/CGCXMgraph.pl"
index = xInit;
		numIn = input.numberPorts();
		count = 0;
}

void CGCXMgraph::go() {
# line 123 "../../../../src/domains/cgc/stars/CGCXMgraph.pl"
count++;
		if (count <= int(ignore)) return;
		for (int i = 1; i <= int(numIn); i++) {
			ix = i;
			iy = i - 1;
			addCode(
"\tfprintf($starSymbol(fp)[$val(iy)],\"%g %g\\n\",$ref(index),$ref(input#ix));\n");
		}
		addCode("\t$ref(index) += $val(xUnits);\n");
}

// prototype instance for known block list
static CGCXMgraph proto;
static KnownBlock entry(proto,"XMgraph");
