static const char file_id[] = "CGCWaveForm.pl";
// .cc file generated from CGCWaveForm.pl by ptlang
/*
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
 */

#ifdef __GNUG__
#pragma implementation
#endif

#include "KnownBlock.h"
#include "CGCWaveForm.h"

const char *star_nm_CGCWaveForm = "CGCWaveForm";

const char* CGCWaveForm :: className() const {return star_nm_CGCWaveForm;}

Block* CGCWaveForm :: makeNew() const { LOG_NEW; return new CGCWaveForm;}

CodeBlock CGCWaveForm :: body (
"	if ($val(haltAtEnd) && ($ref(pos) >= $val(size)))\n"
"		break;\n"
"	else if ($ref(pos) >= $val(size)) {\n"
"		$ref(output) = 0.0;\n"
"		$ref(pos)++;\n"
"	} else {\n"
"		$ref(output) = $ref(value)[$ref(pos)++];\n"
"	}\n"
"	if ($val(periodic))\n"
"	    if($val(period) <= 0 && $ref(pos) >= $val(size)) \n"
"		$ref(pos) = 0;\n"
"	    else if ($val(period) > 0 && $ref(pos) >= $val(period)) \n"
"		$ref(pos) = 0;\n"
);

CGCWaveForm::CGCWaveForm ()
{
	setDescriptor("Output a waveform as specified by the array state \"value\" (default \"1 -1\").\nYou can get periodic signals with any period, and can halt a simulation\nat the end of the given waveform.  The following table summarizes the\ncapabilities:\n\n haltAtEnd   periodic   period    operation\n ------------------------------------------------------------------------\n NO          YES        0         The period is the length of the waveform\n NO          YES        N>0       The period is N\n NO          NO         anything  Output the waveform once, then zeros\n YES         anything   anything  Stop after outputting the waveform once\n\nThe first line of the table gives the default settings.");
	addPort(output.setPort("output",this,FLOAT));
	addState(value.setState("value",this,"1 -1","One period of the output waveform."));
	addState(haltAtEnd.setState("haltAtEnd",this,"NO","Halt the run at the end of the given data."));
	addState(periodic.setState("periodic",this,"YES","Output is periodic if \"YES\" (nonzero)."));
	addState(period.setState("period",this,"0","If greater than zero, gives the period of the waveform."));
	addState(pos.setState("pos",this,"0","pos",
# line 74 "CGCWaveForm.pl"
A_NONSETTABLE));
	addState(size.setState("size",this,"0","size",
# line 80 "CGCWaveForm.pl"
A_NONSETTABLE));


}

void CGCWaveForm::setup() {
# line 83 "CGCWaveForm.pl"
pos = 0;
		size = value.size();
}

void CGCWaveForm::go() {
# line 102 "CGCWaveForm.pl"
addCode(body);
}

// prototype instance for known block list
static CGCWaveForm proto;
static KnownBlock entry(proto,"WaveForm");
