static const char file_id[] = "../../../../src/domains/cgc/stars/CGCReciprocal.pl";
// .cc file generated from ../../../../src/domains/cgc/stars/CGCReciprocal.pl by ptlang
/*
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
 */

#ifdef __GNUG__
#pragma implementation
#endif

#include "KnownBlock.h"
#include "CGCReciprocal.h"

const char *star_nm_CGCReciprocal = "CGCReciprocal";

const char* CGCReciprocal :: className() const {return star_nm_CGCReciprocal;}

Block* CGCReciprocal :: makeNew() const { LOG_NEW; return new CGCReciprocal;}

CodeBlock CGCReciprocal :: reciprocal (
"	$ref(output) = 1/$ref(input);\n"
);

CodeBlock CGCReciprocal :: satrec (
"	if($ref(input) == 0.0)\n"
"	    $ref(output) = $val(magLimit);\n"
"	else {\n"
"	    double t;\n"
"	    t = 1/$ref(input);\n"
"	    if (t>$val(magLimit))\n"
"		$ref(output) = $val(magLimit);\n"
"	    else if (t < - $val(magLimit))\n"
"		$ref(output) = - $val(magLimit);\n"
"	    else\n"
"		$ref(output) = t;\n"
"	}\n"
);

CGCReciprocal::CGCReciprocal ()
{
	setDescriptor("1/x, with an optional magnitude limit.");
	addPort(input.setPort("input",this,FLOAT));
	addPort(output.setPort("output",this,FLOAT));
	addState(magLimit.setState("magLimit",this,"0.0","If non-zero, limits the magnitude of the output."));

# line 36 "../../../../src/domains/cgc/stars/CGCReciprocal.pl"
// Indicate that there is no dynamically changing internal
		// state, so the star can be parallelized.
		noInternalState();
}

void CGCReciprocal::go() {
# line 41 "../../../../src/domains/cgc/stars/CGCReciprocal.pl"
if(double(magLimit) == 0.0)
		addCode(reciprocal);
	    else
		addCode(satrec);
}

// prototype instance for known block list
static CGCReciprocal proto;
static KnownBlock entry(proto,"Reciprocal");
