static const char file_id[] = "CGCQuant.pl";
// .cc file generated from CGCQuant.pl by ptlang
/*
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
 */

#ifdef __GNUG__
#pragma implementation
#endif

#include "KnownBlock.h"
#include "CGCQuant.h"

const char *star_nm_CGCQuant = "CGCQuant";

const char* CGCQuant :: className() const {return star_nm_CGCQuant;}

Block* CGCQuant :: makeNew() const { LOG_NEW; return new CGCQuant;}

CodeBlock CGCQuant :: declarations (
"	    int $starSymbol(siz);\n"
);

CodeBlock CGCQuant :: maindecl (
"		float in;\n"
"		int lo, hi, mid;\n"
);

CodeBlock CGCQuant :: main (
"		in = $ref(input);\n"
"		lo = 0;\n"
"		hi = $starSymbol(siz);\n"
"		mid = (hi+lo)/2;\n"
"		do {\n"
"			if (in <= $ref2(thresholds,mid)) {\n"
"				hi = mid;\n"
"			} else {\n"
"				lo = mid+1;\n"
"			}\n"
"			mid = (hi+lo)/2;\n"
"		} while (mid < $starSymbol(siz) && hi > lo);\n"
"\n"
"		/* now in is <= thresholds[mid] but > all smaller ones. */\n"
"		/* (where thresholds[$starSymbol(siz)] is infinity) */\n"
"\n"
"		$ref(output) = $ref2(levels,mid);\n"
);

CGCQuant::CGCQuant ()
{
	setDescriptor("Quantizes input to one of N+1 possible output levels using N thresholds.\nFor an input less than or equal to the n-th threshold, but larger than all\nprevious thresholds, the output will be the n-th level.  If the input is\ngreater than all thresholds, the output is the N+1-th level.  If level is\nspecified, there must be one more level than thresholds; the default\nvalue for level is 0, 1, 2, ... N.");
	addPort(input.setPort("input",this,FLOAT));
	addPort(output.setPort("output",this,FLOAT));
	addState(thresholds.setState("thresholds",this,"0.0","Quantization thresholds, in increasing order"));
	addState(levels.setState("levels",this,"","Output levels.  If empty, use 0, 1, 2, ..."));


}

void CGCQuant::initCode() {
# line 59 "CGCQuant.pl"
addDeclaration(declarations);
}

void CGCQuant::setup() {
# line 42 "CGCQuant.pl"
int n = thresholds.size();
		if (levels.size() == 0) {
			// default: 0, 1, 2...

			levels.resize(n + 1);
			for (int i = 0; i <= n; i++)
				levels[i] = i;
		}
		else if (levels.size() != n+1) {
			Error::abortRun (*this,
			      "must have one more level than thresholds");
		}
}

void CGCQuant::go() {
# line 85 "CGCQuant.pl"
addCode (maindecl);
	    StringList st = "\t\t$starSymbol(siz) = ";
	    st << thresholds.size();
	    st << ";\n";
	    addCode((const char*)st);
	    addCode (main);
}

// prototype instance for known block list
static CGCQuant proto;
static KnownBlock entry(proto,"Quant");
