static const char file_id[] = "../../../../src/domains/cgc/stars/CGCPrinter.pl";
// .cc file generated from ../../../../src/domains/cgc/stars/CGCPrinter.pl by ptlang
/*
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
 */

#ifdef __GNUG__
#pragma implementation
#endif

#include "KnownBlock.h"
#include "CGCPrinter.h"

const char *star_nm_CGCPrinter = "CGCPrinter";

const char* CGCPrinter :: className() const {return star_nm_CGCPrinter;}

Block* CGCPrinter :: makeNew() const { LOG_NEW; return new CGCPrinter;}

CodeBlock CGCPrinter :: openfile (
"    if(!($starSymbol(fp)=fopen(\"$val(fileName)\",\"w\"))) {\n"
"	fprintf(stderr,\"ERROR: cannot open output file for Printer star.\\n\");\n"
"    	exit(1);\n"
"    }\n"
);

CGCPrinter::CGCPrinter ()
{
	setDescriptor("Prints out one sample from each input port per line\nIf \"fileName\" is not equal to \"cout\" (the default) or \"stdout\", it\nspecifies the filename to write to.");
	addPort(input.setPort("input",this,ANYTYPE));
	addState(fileName.setState("fileName",this,"cout","Filename for output."));
	addState(index.setState("index",this,"1","index for multi input trace.",
# line 38 "../../../../src/domains/cgc/stars/CGCPrinter.pl"
A_NONSETTABLE|A_NONCONSTANT));


}

void CGCPrinter::wrapup() {
# line 80 "../../../../src/domains/cgc/stars/CGCPrinter.pl"
if(fileOutput)
		addCode("\tfclose($starSymbol(fp));\n");
}

void CGCPrinter::initCode() {
# line 44 "../../../../src/domains/cgc/stars/CGCPrinter.pl"
const char *fn = fileName;
	    fileOutput = ! ( fn==NULL
	      || strcmp(fn, "cout")==0 || strcmp(fn, "stdout")==0
	      || strcmp(fn, "<cout>")==0 || strcmp(fn, "<stdout>")==0);
	    if(fileOutput) {
		StringList s;
		s << "    FILE* $starSymbol(fp);";
		addDeclaration(s);
		addInclude("<stdio.h>");
		addCode(openfile);
	    }
}

void CGCPrinter::go() {
# line 63 "../../../../src/domains/cgc/stars/CGCPrinter.pl"
for (int i = 1; i <= input.numberPorts(); i++) {
		index = i;
		if(fileOutput) {
			addCode(
"\tfprintf($starSymbol(fp),\"%f\\t\", $ref(input#index));\n");
		} else {
			addCode( 
"\tprintf(\"%f\\t\", $ref(input#index));\n");
		}
	    }
	    if (fileOutput) {
		addCode("\tfprintf($starSymbol(fp),\"\\n\");\n");
	    } else {
		addCode("\tprintf(\"\\n\");\n");
	   }
}

// prototype instance for known block list
static CGCPrinter proto;
static KnownBlock entry(proto,"Printer");
