static const char file_id[] = "../../../../src/domains/cgc/stars/CGCPCMread.pl";
// .cc file generated from ../../../../src/domains/cgc/stars/CGCPCMread.pl by ptlang
/*
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
 */

#ifdef __GNUG__
#pragma implementation
#endif

#include "KnownBlock.h"
#include "CGCPCMread.h"

const char *star_nm_CGCPCMread = "CGCPCMread";

const char* CGCPCMread :: className() const {return star_nm_CGCPCMread;}

Block* CGCPCMread :: makeNew() const { LOG_NEW; return new CGCPCMread;}

CodeBlock CGCPCMread :: openFile (
"	/* Open file for reading. */\n"
"	if (! ($starSymbol(stream) = fopen(\"$val(fileName)\",\"r\")))\n"
"	{\n"
"		perror(\"$val(fileName)\");\n"
"		exit(1);\n"
"	}\n"
);

CodeBlock CGCPCMread :: noOpen (
"	/* Use standard input for reading. */\n"
"	$starSymbol(stream) = stdin;\n"
);

CodeBlock CGCPCMread :: convert (
"	/* Convert from mu-law PCM to floating point [-1.0,1.0). */\n"
"	{\n"
"	    int exponent, mantissa, magnitude;\n"
"\n"
"	    $starSymbol(byte) = ~$starSymbol(byte);\n"
"	    exponent = ($starSymbol(byte) >> 4) & 0x7;\n"
"	    mantissa = $starSymbol(byte) & 0xf;\n"
"	    magnitude = $sharedSymbol(PCM,offset)[exponent] + (mantissa << exponent);\n"
"	    $ref(output) = magnitude / 4080.0;\n"
"	    if ($starSymbol(byte) & 0x80) $ref(output) = -$ref(output);\n"
"	}\n"
);

CodeBlock CGCPCMread :: read (
"	/* Read data from file. */\n"
"	if (!fread(&$starSymbol(byte),1,1,$starSymbol(stream)))\n"
"	{\n"
"	    perror(\"$val(fileName)\");\n"
"	    exit(1);\n"
"	}\n"
);

CGCPCMread::CGCPCMread ()
{
	setDescriptor("Read mu-law PCM from a file and convert to linear floating point.\nThe file can be the audio port /dev/audio, if supported by the workstation.");
	addPort(output.setPort("output",this,FLOAT));


}

void CGCPCMread::wrapup() {
# line 87 "../../../../src/domains/cgc/stars/CGCPCMread.pl"
if (!standardIO)
	    addCode(closeFile);
}

void CGCPCMread::initCode() {
# line 68 "../../../../src/domains/cgc/stars/CGCPCMread.pl"
CGCPCM::initCode();
	if (standardIO)
	{
	    addCode(noOpen);
	}
	else
	{
	    addCode(openFile);
	}
}

void CGCPCMread::go() {
# line 81 "../../../../src/domains/cgc/stars/CGCPCMread.pl"
addCode(read);
	addCode(convert);
}

// prototype instance for known block list
static CGCPCMread proto;
static KnownBlock entry(proto,"PCMread");
