static const char file_id[] = "../../../../src/domains/cgc/stars/CGCPCM.pl";
// .cc file generated from ../../../../src/domains/cgc/stars/CGCPCM.pl by ptlang
/*
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
 */

#ifdef __GNUG__
#pragma implementation
#endif

#include "KnownBlock.h"
#include "CGCPCM.h"

const char *star_nm_CGCPCM = "CGCPCM";

const char* CGCPCM :: className() const {return star_nm_CGCPCM;}

Block* CGCPCM :: makeNew() const { LOG_NEW; return new CGCPCM;}

CodeBlock CGCPCM :: sharedDeclarations (
"	int $sharedSymbol(PCM,offset)[8];\n"
"\n"
"	/* Convert from linear to mu-law */\n"
"	int $sharedSymbol(PCM,mulaw)(x)\n"
"	double x;\n"
"	{\n"
"	    double m;\n"
"	    m = (pow(256.0,fabs(x)) - 1.0) / 255.0;\n"
"	    return 4080.0 * m;\n"
"	}\n"
);

CodeBlock CGCPCM :: sharedInit (
"	/* Initialize PCM offset table. */\n"
"	{\n"
"	    int i;\n"
"	    double x = 0.0;\n"
"	    double dx = 0.125;\n"
"\n"
"	    for(i = 0; i < 8; i++, x += dx)\n"
"	    {\n"
"		$sharedSymbol(PCM,offset)[i] = $sharedSymbol(PCM,mulaw)(x);\n"
"	    }\n"
"	}\n"
);

CodeBlock CGCPCM :: declarations (
"	FILE* $starSymbol(stream);\n"
"	unsigned char $starSymbol(byte);\n"
);

CodeBlock CGCPCM :: closeFile (
"	/* Close file. */\n"
"	if (fclose($starSymbol(stream)) != 0)\n"
"	{\n"
"	    perror(\"$val(fileName)\");\n"
"	    exit(1);\n"
"	}\n"
);

CGCPCM::CGCPCM ()
{
	setDescriptor("Base class for reading and writing mu-law encoded PCM data.");
	addState(fileName.setState("fileName",this,"/dev/audio","File for PCM data.  If blank, use standard IO."));


}

void CGCPCM::initCode() {
# line 80 "../../../../src/domains/cgc/stars/CGCPCM.pl"
addInclude("<math.h>");
	addInclude("<stdio.h>");
	addDeclaration(declarations);
	if (addGlobal(sharedDeclarations, "$sharedSymbol(PCM,PCM)"))
	    addCode(sharedInit);
}

void CGCPCM::setup() {
# line 30 "../../../../src/domains/cgc/stars/CGCPCM.pl"
standardIO = strcmp(fileName,"") == 0;
}

// prototype instance for known block list
static CGCPCM proto;
static KnownBlock entry(proto,"PCM");
