static const char file_id[] = "CGCIntegrator.pl";
// .cc file generated from CGCIntegrator.pl by ptlang
/*
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
 */

#ifdef __GNUG__
#pragma implementation
#endif

#include "KnownBlock.h"
#include "CGCIntegrator.h"

const char *star_nm_CGCIntegrator = "CGCIntegrator";

const char* CGCIntegrator :: className() const {return star_nm_CGCIntegrator;}

Block* CGCIntegrator :: makeNew() const { LOG_NEW; return new CGCIntegrator;}

CodeBlock CGCIntegrator :: declarations (
"	    double $starSymbol(t);\n"
);

CodeBlock CGCIntegrator :: integrate (
"	    if ($ref(reset) != 0) {\n"
"		$starSymbol(t) = $ref(data);\n"
"	    } else {\n"
"		$starSymbol(t) = $ref(data) +\n"
"			$val(feedbackGain) * $ref(state);\n"
"	    }\n"
);

CodeBlock CGCIntegrator :: limitWithSat (
"	    /* Limiting is in effect */\n"
"	    /* Take care of the top */\n"
"	    if ($starSymbol(t) > $val(top)) $starSymbol(t) = $val(top);\n"
"	    /* Take care of the bottom */\n"
"	    if ($starSymbol(t) < $val(bottom)) $starSymbol(t) = $val(bottom);\n"
);

CodeBlock CGCIntegrator :: limitWithoutSat (
"	    /* Limiting is in effect */\n"
"	    /* Take care of the top */\n"
"	    if ($starSymbol(t) > $val(top))\n"
"		do $starSymbol(t) -= ($val(top) - $val(bottom));\n"
"		while ($starSymbol(t) > $val(top));\n"
"	    /* Take care of the bottom */\n"
"	    if ($starSymbol(t) < $val(bottom))\n"
"		do $starSymbol(t) += ($val(top) - $val(bottom));\n"
"		while ($starSymbol(t) < $val(bottom));\n"
);

CodeBlock CGCIntegrator :: write (
"	    $ref(output) = $starSymbol(t);\n"
"	    $ref(state) = $starSymbol(t);\n"
);

CGCIntegrator::CGCIntegrator ()
{
	setDescriptor("An integrator with leakage, limits, and reset.\nWith the default parameters, input samples are simply accumulated,\nand the running sum is the output.  To prevent any resetting in the\nmiddle of a run, connect a d.c. source with value 0.0 to the \"reset\"\ninput.  Otherwise, whenever a non-zero is received on this input,\nthe accumulated sum is reset to the current input (i.e. no feedback).\n\nLimits are controlled by the \"top\" and \"bottom\" parameters.\nIf top <= bottom, no limiting is performed (default).  Otherwise,\nthe output is kept between \"bottom\" and \"top\".  If \"saturate\" = YES,\nsaturation is performed.  If \"saturate\" = NO, wrap-around is performed\n(default).  Limiting is performed before output.\n\nLeakage is controlled by the \"feedbackGain\" state (default 1.0).\nThe output is the data input plus feedbackGain*state, where state\nis the previous output.");
	addPort(data.setPort("data",this,FLOAT));
	addPort(reset.setPort("reset",this,INT));
	addPort(output.setPort("output",this,FLOAT));
	addState(feedbackGain.setState("feedbackGain",this,"1.0","The gain on the feedback path."));
	addState(top.setState("top",this,"0.0","The upper limit."));
	addState(bottom.setState("bottom",this,"0.0","The lower limit."));
	addState(saturate.setState("saturate",this,"YES","Saturate if YES, wrap around otherwise."));
	addState(state.setState("state",this,"0.0","An internal state.",
# line 76 "CGCIntegrator.pl"
A_NONCONSTANT|A_SETTABLE));


}

void CGCIntegrator::initCode() {
# line 88 "CGCIntegrator.pl"
addDeclaration(declarations);
}

void CGCIntegrator::setup() {
# line 82 "CGCIntegrator.pl"
spread = double(top) - double(bottom);
}

void CGCIntegrator::go() {
# line 121 "CGCIntegrator.pl"
addCode(integrate);
	    if (spread > 0.0) 
		if (int(saturate))
		    addCode(limitWithSat);
		else
		    addCode(limitWithoutSat);
	    addCode(write);
}

// prototype instance for known block list
static CGCIntegrator proto;
static KnownBlock entry(proto,"Integrator");
