static const char file_id[] = "CGCFIR.pl";
// .cc file generated from CGCFIR.pl by ptlang
/*
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
 */

#ifdef __GNUG__
#pragma implementation
#endif

#include "KnownBlock.h"
#include "CGCFIR.h"

const char *star_nm_CGCFIR = "CGCFIR";

const char* CGCFIR :: className() const {return star_nm_CGCFIR;}

Block* CGCFIR :: makeNew() const { LOG_NEW; return new CGCFIR;}

CodeBlock CGCFIR :: bodyDecl (
"	int phase, tapsIndex, inC, i;\n"
"	int outCount = $val(interpolation) - 1;\n"
"	int inPos;\n"
"	double out, tap;\n"
);

CodeBlock CGCFIR :: body (
"	/* phase keeps track of which phase of the filter coefficients is used.\n"
"	   Starting phase depends on the decimationPhase state. */\n"
"	phase = $val(decimation) - $val(decimationPhase) - 1;   \n"
"	\n"
"	/* Iterate once for each input consumed */\n"
"	for (inC = 1; inC <= $val(decimation) ; inC++) {\n"
"\n"
"		/* Produce however many outputs are required for each \n"
"		   input consumed */\n"
"		while (phase < $val(interpolation)) {\n"
"			out = 0.0;\n"
"\n"
"			/* Compute the inner product. */\n"
"			for (i = 0; i < $val(phaseLength); i++) {\n"
"				tapsIndex = i * $val(interpolation) + phase;\n"
"				if (tapsIndex >= $val(tapSize))\n"
"			    		tap = 0.0;\n"
"				else\n"
"			 		tap = $ref2(taps,tapsIndex);\n"
"				inPos = $val(decimation) - inC + i;\n"
"				out += tap * $ref2(signalIn,inPos);\n"
"			}\n"
"			$ref2(signalOut,outCount) = out;\n"
"			outCount--;;\n"
"			phase += $val(decimation);\n"
"		}\n"
"		phase -= $val(interpolation);\n"
"	}\n"
);

CGCFIR::CGCFIR ()
{
	setDescriptor("A Finite Impulse Response (FIR) filter.\nCoefficients are in the \"taps\" state variable.\nDefault coefficients give an 8th order, linear phase lowpass\nfilter. To read coefficients from a file, replace the default\ncoefficients with \"<fileName\".");
	addPort(signalIn.setPort("signalIn",this,FLOAT));
	addPort(signalOut.setPort("signalOut",this,FLOAT));
	addState(taps.setState("taps",this,"-.040609 -.001628 .17853 .37665 .37665 .17853 -.001628 -.040609","Filter tap values."));
	addState(decimation.setState("decimation",this,"1","Decimation ratio."));
	addState(decimationPhase.setState("decimationPhase",this,"0","Downsampler phase."));
	addState(interpolation.setState("interpolation",this,"1","Interpolation ratio."));
	addState(phaseLength.setState("phaseLength",this,"0","phaseLength",
# line 110 "CGCFIR.pl"
A_NONCONSTANT|A_NONSETTABLE));
	addState(tapSize.setState("tapSize",this,"0","tapSize",
# line 116 "CGCFIR.pl"
A_NONCONSTANT|A_NONSETTABLE));


}

void CGCFIR::setup() {
# line 119 "CGCFIR.pl"
int d = decimation;
		int i = interpolation;
		int dP = decimationPhase;
		signalIn.setSDFParams(d, d+1+(taps.size()/i));
		signalOut.setSDFParams(i, i-1);
		if (dP >= d) {
			Error::abortRun (*this, ": decimationPhase too large");
			return;
		}
		// The phaseLength is ceiling(taps.size/interpolation)
		// It is a protected instance variable.
		int temp = taps.size() / i;
		tapSize = taps.size();
		if ((taps.size() % i) != 0)  temp++;
		phaseLength = temp;
}

void CGCFIR::go() {
# line 173 "CGCFIR.pl"
addCode(bodyDecl);
		addCode(body);
}

// prototype instance for known block list
static CGCFIR proto;
static KnownBlock entry(proto,"FIR");
