static const char file_id[] = "../../../../src/domains/cgc/stars/CGCFFTCx.pl";
// .cc file generated from ../../../../src/domains/cgc/stars/CGCFFTCx.pl by ptlang
/*
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
 */

#ifdef __GNUG__
#pragma implementation
#endif

#include "KnownBlock.h"
#include "CGCFFTCx.h"

const char *star_nm_CGCFFTCx = "CGCFFTCx";

const char* CGCFFTCx :: className() const {return star_nm_CGCFFTCx;}

Block* CGCFFTCx :: makeNew() const { LOG_NEW; return new CGCFFTCx;}

CodeBlock CGCFFTCx :: fftRoutine (
"\n"
"/*\n"
" * This fft routine is from ~gabriel/src/filters/fft/fft.c;\n"
" * I am unsure of the original source.  The file contains no\n"
" * copyright notice or description.\n"
" * The declaration is changed to the prototype form but the\n"
" * function body is unchanged.  (J. T. Buck)\n"
" */\n"
"\n"
"#define SWAP(a, b) tempr=(a); (a)=(b); (b)=tempr\n"
"\n"
"/*\n"
" * Replace data by its discrete Fourier transform, if isign is\n"
" * input as 1, or by its inverse discrete Fourier transform, if \n"
" * \"isign\" is input as -1.  \"data'\"is a complex array of length \"nn\",\n"
" * input as a real array data[0..2*nn-1]. \"nn\" MUST be an integer\n"
" * power of 2 (this is not checked for!?)\n"
" */\n"
"\n"
"static void fft_rif(data, nn, isign)\n"
"double* data;\n"
"int nn, isign;\n"
"{\n"
"	int	n;\n"
"	int	mmax;\n"
"	int	m, j, istep, i;\n"
"	double	wtemp, wr, wpr, wpi, wi, theta;\n"
"	double	tempr, tempi;\n"
"\n"
"	data--;\n"
"	n = nn << 1;\n"
"	j = 1;\n"
"\n"
"	for (i = 1; i < n; i += 2) {\n"
"		if(j > i) {\n"
"			SWAP(data[j], data[i]);\n"
"			SWAP(data[j+1], data[i+1]);\n"
"		}\n"
"		m= n >> 1;\n"
"		while (m >= 2 && j >m) {\n"
"			j -= m;\n"
"			m >>= 1;\n"
"		}\n"
"		j += m;\n"
"	}\n"
"	mmax = 2;\n"
"	while (n > mmax) {\n"
"		istep = 2*mmax;\n"
"		theta = -6.28318530717959/(isign*mmax);\n"
"		wtemp = sin(0.5*theta);\n"
"		wpr = -2.0*wtemp*wtemp;\n"
"		wpi = sin(theta);\n"
"		wr = 1.0;\n"
"		wi = 0.0;\n"
"		for (m = 1; m < mmax; m += 2) {\n"
"			for (i = m; i < n; i += istep) {\n"
"				j = i + mmax;\n"
"				tempr = wr*data[j] - wi*data[j+1];\n"
"				tempi = wr*data[j+1] + wi*data[j];\n"
"				data[j] = data[i] - tempr;\n"
"				data[j+1] = data[i+1] - tempi;\n"
"				data[i] += tempr;\n"
"				data[i+1] += tempi;\n"
"			}\n"
"			wr = (wtemp=wr)*wpr - wi*wpi+wr;\n"
"			wi = wi*wpr + wtemp*wpi + wi;\n"
"		}\n"
"		mmax = istep;\n"
"	}\n"
"}\n"
"\n"
);

CodeBlock CGCFFTCx :: loadCode (
"	int i, j = 0;\n"
"	for (i = $val(size) - 1; i > 0; i--) {\n"
"		$ref(localData,j++) = $ref(input,i).real;\n"
"		$ref(localData,j++) = $ref(input,i).imag;\n"
"	}\n"
"	fft_rif ($ref(localData),$val(fftSize), $val(direction));\n"
);

CodeBlock CGCFFTCx :: scaleOut (
"	for (i = 0; i < 2*$val(fftSize); i++)\n"
"		$ref(localData,i) /= $val(fftSize);\n"
);

CodeBlock CGCFFTCx :: outData (
"	j = 0;\n"
"	for (i = $val(fftSize) - 1; i >= 0; i--) {\n"
"		$ref(output,i).real = $ref(localData,j++);\n"
"		$ref(output,i).imag = $ref(localData,j++);\n"
"	}\n"
);

CGCFFTCx::CGCFFTCx ()
{
	setDescriptor("Complex Fast Fourier transform.\nParameter \"order\" (default 8) is the log, base 2, of the transform size.\nParameter \"size\" (default 256) is the number of samples read (<= 2^order).\nParameter \"direction\" (default 1) is 1 for forward, -1 for inverse FFT.");
	addPort(input.setPort("input",this,COMPLEX));
	addPort(output.setPort("output",this,COMPLEX));
	addState(order.setState("order",this,"8","Log base 2 of the transform size."));
	addState(size.setState("size",this,"256","Number of input samples to read."));
	addState(direction.setState("direction",this,"1","= 1 for forward, = -1 for inverse."));
	addState(localData.setState("localData",this,"0","localData",
# line 73 "../../../../src/domains/cgc/stars/CGCFFTCx.pl"
A_NONSETTABLE));
	addState(fftSize.setState("fftSize",this,"256","fftSize",
# line 80 "../../../../src/domains/cgc/stars/CGCFFTCx.pl"
A_NONSETTABLE));

# line 84 "../../../../src/domains/cgc/stars/CGCFFTCx.pl"
noInternalState();
}

void CGCFFTCx::setup() {
# line 163 "../../../../src/domains/cgc/stars/CGCFFTCx.pl"
int temp = 1 << int(order);
		if (temp < int(size)) {
			Error::abortRun(*this, "2^order must be >= size");
			return;
		} 

		localData.resize(temp * 2);
		input.setSDFParams (int(size), int(size)-1);
		output.setSDFParams (temp, temp-1);
		fftSize = temp;

		// add fft routine
		addProcedure(fftRoutine);
}

void CGCFFTCx::go() {
# line 201 "../../../../src/domains/cgc/stars/CGCFFTCx.pl"
addCode(loadCode);

		// generate output data.  If inverse, we must scale the result.
		if (int(direction) != 1)
			addCode(scaleOut);

		addCode(outData);
}

// prototype instance for known block list
static CGCFFTCx proto;
static KnownBlock entry(proto,"FFTCx");
