static const char file_id[] = "CGCDownSample.pl";
// .cc file generated from CGCDownSample.pl by ptlang
/*
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
 */

#ifdef __GNUG__
#pragma implementation
#endif

#include "KnownBlock.h"
#include "CGCDownSample.h"

const char *star_nm_CGCDownSample = "CGCDownSample";

const char* CGCDownSample :: className() const {return star_nm_CGCDownSample;}

Block* CGCDownSample :: makeNew() const { LOG_NEW; return new CGCDownSample;}

CodeBlock CGCDownSample :: sendsample (
"	$ref(output) = $ref2(input,phase);\n"
);

CGCDownSample::CGCDownSample ()
{
	setDescriptor("A decimator by \"factor\" (default 2).  The \"phase\" tells which sample to\noutput.  If phase = 0, the most recent sample is the output, while if\nphase = factor-1 the oldest sample is the output.  Phase = 0 is the\ndefault.");
	addPort(input.setPort("input",this,FLOAT));
	addPort(output.setPort("output",this,FLOAT));
	addState(factor.setState("factor",this,"2","Downsample factor.",
# line 32 "CGCDownSample.pl"
A_SETTABLE));
	addState(phase.setState("phase",this,"0","Downsample phase.",
# line 39 "CGCDownSample.pl"
A_SETTABLE));

# line 42 "CGCDownSample.pl"
noInternalState();
}

void CGCDownSample::setup() {
# line 45 "CGCDownSample.pl"
input.setSDFParams(int(factor),int(factor)-1);
		if (int(phase) >= int(factor))
			Error::abortRun(*this, ": phase must be < factor");
}

void CGCDownSample::go() {
# line 53 "CGCDownSample.pl"
addCode(sendsample);
}

// prototype instance for known block list
static CGCDownSample proto;
static KnownBlock entry(proto,"DownSample");
