static const char file_id[] = "CGCCommutator.pl";
// .cc file generated from CGCCommutator.pl by ptlang
/*
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
 */

#ifdef __GNUG__
#pragma implementation
#endif

#include "KnownBlock.h"
#include "CGCCommutator.h"

const char *star_nm_CGCCommutator = "CGCCommutator";

const char* CGCCommutator :: className() const {return star_nm_CGCCommutator;}

Block* CGCCommutator :: makeNew() const { LOG_NEW; return new CGCCommutator;}

CGCCommutator::CGCCommutator ()
{
	setDescriptor("Takes N input streams (where N is the number of inputs) and\nsynchronously combines them into one output stream.\nIt consumes B input particles from each\ninput (where B is the blockSize), and produces N*B particles on the\noutput.\nThe first B particles on the output come from the first input,\nthe next B particles from the next input, etc.");
	addPort(input.setPort("input",this,ANYTYPE));
	addPort(output.setPort("output",this,ANYTYPE));
	output.inheritTypeFrom(input);
	addState(blockSize.setState("blockSize",this,"1","Number of particles in a block."));
	addState(ix.setState("ix",this,"1","index for multiple output trace",
# line 41 "CGCCommutator.pl"
A_NONSETTABLE|A_NONCONSTANT));


}

void CGCCommutator::setup() {
# line 44 "CGCCommutator.pl"
int n = input.numberPorts();
		input.setSDFParams(int(blockSize),int(blockSize)-1);
		output.setSDFParams(n*int(blockSize),n*int(blockSize)-1);
}

void CGCCommutator::go() {
# line 49 "CGCCommutator.pl"
StringList out;
		if(int(blockSize) > 1) out << "\tint j;\n";
		for (int i = input.numberPorts()-1; i >= 0; i--) {
		    ix = input.numberPorts() - i;
		    if(int(blockSize) > 1) {
			out << "\tfor (j = ";
			out << int(blockSize)-1;
			out << "; j >= 0; j--)\n";
			out << "\t\t$ref2(output,j+";
			out << i*int(blockSize);
			out << ") = $ref2(input#ix,j";
		   } else {
			out << "\t$ref2(output,";
			out << i;
			out << ") = $ref2(input#ix,0";
		   }
		   out << ");\n";
		   addCode(out);
		   out.initialize();
		}
}

// prototype instance for known block list
static CGCCommutator proto;
static KnownBlock entry(proto,"Commutator");
