static const char file_id[] = "Sim96Target.cc";
/******************************************************************
Version identification:
@(#)Sim96Target.cc	1.13	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer: J. Buck, J. Pino

 Target for Motorola 96000 assembly code generation that runs its
 output on the simulator.

*******************************************************************/

#ifdef __GNUG__
#pragma implementation
#endif

#include "Sim96Target.h"
#include "KnownTarget.h"
#include "MotorolaTarget.h"

Sim96Target :: Sim96Target(const char* nam, const char* desc) :
MotorolaTarget(nam,desc,"CG96Star"),CG96Target(nam,desc),MotorolaSimTarget(nam,desc,"CG96Star")
{
	initStates();
}

Sim96Target::Sim96Target(const Sim96Target& arg) :
MotorolaTarget(arg),CG96Target(arg),MotorolaSimTarget(arg)
{
	initStates();
	copyStates(arg);
}

void Sim96Target :: initStates() {
	MotorolaSimTarget::initStates("96000","200","3f00");
}

int Sim96Target::compileCode() {
	return MotorolaSimTarget::compileCode();
}

int Sim96Target::loadCode() {
	return MotorolaSimTarget::loadCode();
}

int Sim96Target::runCode() {
	return MotorolaSimTarget::runCode();
}

void Sim96Target :: headerCode () {
	CG96Target :: headerCode();
	MotorolaSimTarget :: headerCode();
};

Block* Sim96Target::makeNew() const {
	LOG_NEW; return new Sim96Target(*this);
}

void Sim96Target :: trailerCode () {
	MotorolaSimTarget::trailerCode();
	CG96Target::trailerCode();
}

ISA_FUNC(Sim96Target,CG96Target);

// make an instance
static Sim96Target proto("sim-CG96","run code on the 96000 simulator");

static KnownTarget entry(proto, "sim-CG96");
