defstar {
	name { Thresh }
	domain { CG96 }
	desc { Threshold Detector }
	version { @(#)CG96Thresh.pl	1.6 12/1/92 }
	author { Chih-Tsung Huang }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG96 nonlinear functions library }
	explanation {
This star zeroes out input data
that are smaller than the threshold in magnitude.
Input data larger than the threshold in magnitude
are passed through unchanged.
	}
        seealso { CG96Limit }
	execTime {
		return 7;
	}
	input {
		name {input}
		type {float}
	}
	output {
		name {output}
		type {float}
	}
        state {
                name {threshold}
	        type {float}
	        default { 0.1 }
	        desc {threshold value}
        }
	codeblock (main) {
        move    #$val(threshold),d1.s
        move    $ref(input),d0.s
        fcmpm   d1.s,d0.s
        jpl     $label(end)
        fclr    d0.s
$label(end)
        move    d0.s,$ref(output)
	}

	go {
		addCode(main);
	}
}
