defstar {
	name { Sqrt }
	domain { CG96 }
	desc { Square root function }
	version { @(#)CG96Sqrt.pl	1.5 12/1/92 }
	author { Chih-Tsung Huang }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG96 nonlinear functions library }
	explanation {
.PP
This star calculates the square root of the input by
the Newton-Raphson Approximation method.
        }    

	input {
		name { input }
		type { float }
 	}
	output {
		name { output }
		type { float }
	}
        codeblock(main) {
        move    $ref(input),d0.s
        fseedr  d0,d4
        fmpy.s  d4,d4,d2        #.5,d7.s
        fmpy.s  d0,d2,d2        #3.0,d3.s
        fmpy    d4,d7,d2        fsub.s d2,d3    d3.s,d6.s
        fmpy.s  d2,d3,d4        d6.s,d3.s
        fmpy.s  d4,d4,d2
        fmpy.s  d0,d2,d2
        fmpy    d4,d7,d2        fsub.s d2,d3    d3.s,d6.s
        fmpy.s  d2,d3,d4
        fmpy.s  d0,d4,d4
        move    d4.s,$ref(output)
        }

	go {
                addCode(main);
	}
	execTime {
                return 165;
       }
}
