defstar {
	name { Repeat }
	domain { CG96 }
	desc { Repeats each input sample the specified number of times. }
	version { @(#)CG96Repeat.pl	1.7 12/8/92 }
	author { Chih-Tsung Huang }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG56 demo library }
	explanation {
Repeat repeats each input Particle the specified number of times
(\fInumTimes\fR) on the output.  Note that this is a sample rate
change, and hence affects the number of invocations of downstream
stars.
	}
        seealso { CG96Upsample, CG96Downsample }
	input {
		name {input}
		type {anytype}
	}
	output {
		name {output}
		type {=input}
	}
	state {
		name {numTimes}
		type {int}
		default {2}
		desc { ratio }
	}
        setup {
		output.setSDFParams(int(numTimes),int(numTimes)-1);
	}
	codeblock (initfill) {
; initialization code for star $fullname() - class CG96UpSample
	move	#$addr(output),r1
        move    $ref(input),d0.s
	}
        codeblock(repeat) {
        rep     #$val(numTimes)
        }
        codeblock(done) {
        move    d0.s,x:(r1)+
        }
	go {
                addCode(initfill);
		if(numTimes>1) addCode(repeat);
		addCode(done);
	}
	execTime {
		return 4+int(numTimes);
	}
}
