defstar {
	name { Reciprocal }
	domain { CG96 }
	desc { Reciprocal of input }
	version { @(#)CG96Reciprocal.pl	1.6 12/1/92 }
	author { Chih-Tsung Huang }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG96 nonlinear functions library }
	explanation {
DSP96000 - Output Reciprocal of the input with 32 bit accuracy.
This star computes $1/x$, where $x$ is the input.
If the \fImagLimit\fR parameter is not 0.0, then the output is
$+- ~ max ( magLimit, ~ 1/x )$.  In this case, $x$ can be zero
without causing an floating exception.
The sign of the output is determined by the sign of the input.
	}
	input {
		name {input}
		type {float}
	}
	output {
		name {output}
		type {float}
	}
        state {
		name{magLimit}
		type{float}
		default{"0.0"}
		desc {If non-zero, limits the magnitude of the output.}
	}
	
	codeblock (main) {
        move    $ref(input),d1.s
        fseedd  d1,d6
        fmpy.s  d1,d6,d1        #2.0,d4.s
        fsub.s  d1,d4           d4.s,d3.s
        fmpy.s  d1,d4,d1
        fmpy    d6,d4,d1        fsub.s d1,d3
        fmpy.s  d1,d3,d1
        move    d1.s,$ref(output)
	}

	codeblock (other) {
        move    $ref(input),d1.s
        fseedd  d1,d6
        fmpy.s  d1,d6,d1        #2.0,d4.s
        fsub.s  d1,d4           d4.s,d3.s
        fmpy.s  d1,d4,d1
        fmpy    d6,d4,d1        fsub.s d1,d3
        fmpy.s  d1,d3,d1
        move    #$val(magLimit),d0.s
        fcmp    d1.s,d0.s
; If input exceeds magLimit, jump
	jpl	$label(exceeded)
	move	d0.s,d1.s
$label(exceeded)
        move    d1.s,$ref(output)
	}

	go {
		if(magLimit==0)
			addCode(main);
		else
			addCode(other);
	}
	exectime {
		if(magLimit==0)
			return 8;
		else
			return 12;	
	}
}


