defstar {
	name { ReadFile }
	domain { CG96 }
	desc { Reads data from file for use by simulator.}
	version { @(#)CG96ReadFile.pl	1.7 12/1/92 }
	author { Chih-Tsung Huang }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG96 signal sources library }
	explanation {
Reads data from file for use by simulator.
	}
	execTime {
		return 2;	}
	output {
		name {output}
		type {float}
	}
	state {
		name { fileName }
		type { STRING }
		default { "infile" }
		desc { 'Root' of filename that gets the data. '.sim' is appended.}
	}
	state {
		name { inVal}
		type { float }
		attributes { A_NONCONSTANT|A_NONSETTABLE }
		default { "0"}
	}

	codeblock (logIn) {
input $ref(inVal) $val(fileName).sim -RF
}
	initCode {
                addCode(logIn,"simulatorCmds");
	}

	// this codeblock produces code
	codeblock (copy) {
	move	$ref(inVal),d0.s
	move	d0.s,$ref(output)
	}
	go {
		addCode(copy);
	}
}



