defstar {
	name { Poly }
	domain { CG96 }
	desc { Polynomial evaluation for real numbers}
	version { @(#)CG96Poly.pl	1.10 12/1/92 }
	author { Chih-Tsung Huang (ported from Gabriel) }
        acknowledge { Gabriel version by Anthony Wong }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG96 nonlinear functions library }
	explanation {
.PP
The star applies the polynomial function to its input to obtain the output.
The polynomial function is specified in either the \fIcoef\fR paramter or
by <\fIfilename\fR.
.PP
The coefficients should be entered in such a way that
the first coefficient corresponds to the highest power.
The power of the polymomial is thus determined by the
number of coefficients,
and is one less than the number of coefficients.
	}
	input {
		name {input}
		type {float}
	}
	output {
		name {output}
		type {float}
	}
        state  {
                name { coef }
                type { floatarray }
                default { "0.1 0.2 0.3 0.4" }
                desc { coefficient file, can come from file by <filename}
                attributes { A_NONCONSTANT|A_YMEM }
        }
        state  {
                name { order }
                type { int }
                default { 3 }
                desc { internal }
                attributes { A_NONCONSTANT|A_NONSETTABLE }
        }
	codeblock (main) {
        move    #<$addr(coef),r0
        move    $ref(input),d0.s
        move    y:(r0)+,d1.s
        do      #$val(order),$label(loop)
        fmpy.s  d1,d0,d1        y:(r0)+,d4.s
        fadd.s  d4,d1
$label(loop)
        move    d1.s,$ref(output)
	}
	codeblock (one) {
        move    $ref(input),d1.s
        move    $ref(coef),d2.s
        fmpy.s  d1,d2,d0        y:1,d2.s
        fadd.s  d2.s,d0.s
        move    d0.s,$ref(output)
	}
	codeblock (zero) {
        move    $ref(coef),d0.s
        move    d0.s,$ref(output)
	}

	go {
                order=coef.size()-1;
                if(order>1) addCode(main);
		if(order==1) addCode(one);
		if(order==0) addCode(zero);
	}
	exectime {
                int a =int(coef.size())-1;
                if (a>1)  return 2*a+6;
                if (a==1) return 6;
	        return 2;
	}
}
