defstar {
	name { MaxMin }
	domain { CG96 }
	desc { Finds Maximum or Minimum value. }
	version {@(#)CG96MaxMin.pl	1.5 12/8/92}
	author { Chih-Tsung Huang }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG96 nonlinear functions library }
	explanation {
If \fIcompareMagnitude\fR is ``no'',
the star finds from among the \fIinput\fR inputs the one
with the minimum or maximum value;
else it finds from among the \fIinput\fR
inputs the one with the minimum or maximum magnitude.
if \fIoutputMagnitude\fR is ``yes'',
the magnitude of the result is written to the output,
else the result itself is written to the output.
}
	input {
		name {input}
		type {float}
	}
	output {
		name {output}
		type {float}
	}
	state {
		name {N}
		type {int}
		default {10}
		desc {default samples}
	}
	state {
                name {MAX}
	        type {int}
	        default {"YES"}
	        desc {output maximum value else minimum is the output}
       }
       
	state {
		name {compareMagnitude}
		type {int}
		default {"NO"}
		desc {default is not to compare magnitude}
	}    
	state {
		name {outputMagnitude}
		type {int}
		default {"NO"}
		desc {default is not to output magnitude}
	}    

	setup {
		input.setSDFParams(int(N),int(N)-1);
	}		
	
        codeblock(main) {
        move    #<$addr(input),r0
        nop
        move    x:(r0)+,d0.s
        do      #$val(N)-1,$starSymbol(end)
        move    x:(r0)+,d1.s
        }
        codeblock(cmpMagYes) {
        fcmpm   d1.s,d0.s
        }
        codeblock(cmpMagNo) {
        fcmp    d1.s,d0.s
        }
        codeblock(maxcont) {
        jpl     $starSymbol(done)
        move    d1.s,d0.s
$starSymbol(done)
        nop
$starSymbol(end)
	}
        codeblock(mincont) {
        jmi     $starSymbol(done)
        move    d1.s,d0.s
$starSymbol(done)
        nop
$starSymbol(end)
        }
        codeblock(one) {
        move    $ref(input),d0.s
        }
        codeblock(outMagYes) {  
        fabs.s  d0.s
        }
        codeblock(out) {
        move    d0.s,$ref(output)
        }
 	go {
		if(N>1) {
			addCode(main);

			if(int(compareMagnitude))
				addCode(cmpMagYes);
			else
				addCode(cmpMagNo);
			if (int(MAX))
				addCode(maxcont);
			else
				addCode(mincont);
		}
	        else
	            addCode(one);

		if(int(outputMagnitude))
			addCode(outMagYes);

		addCode(out);
        }   

	exectime {
                if(int(N)>10)
	            return ((int(N)-1)*6)+7;
		else
                    return 3;
 	}
}
